/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.util.Histogram;
import java.util.List;
import picard.sam.markduplicates.ElcHashBasedDuplicatesFinder;
import picard.sam.markduplicates.ElcIdenticalBasesDuplicatesFinder;
import picard.sam.markduplicates.EstimateLibraryComplexity;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

class ElcDuplicatesFinderResolver {
    private static final int BOUNDARY_LIBRARY_SIZE = 100;
    private boolean useBarcodes;
    private ElcHashBasedDuplicatesFinder hashBasedDuplicatesFinder;
    private ElcIdenticalBasesDuplicatesFinder identicalBasesDuplicateFinder;

    ElcDuplicatesFinderResolver(double maxDiffRate, int maxReadLength, int minIdenticalBases, boolean useBarcodes, OpticalDuplicateFinder opticalDuplicateFinder) {
        this.useBarcodes = useBarcodes;
        this.hashBasedDuplicatesFinder = new ElcHashBasedDuplicatesFinder(maxDiffRate, maxReadLength, minIdenticalBases, opticalDuplicateFinder);
        this.identicalBasesDuplicateFinder = new ElcIdenticalBasesDuplicatesFinder(maxDiffRate, maxReadLength, minIdenticalBases, useBarcodes, opticalDuplicateFinder);
    }

    void resolveAndSearch(List<EstimateLibraryComplexity.PairedReadSequence> sequences, Histogram<Integer> duplicationHisto, Histogram<Integer> opticalHisto) {
        if (this.useBarcodes || sequences.size() < 100) {
            this.identicalBasesDuplicateFinder.searchDuplicates(sequences, duplicationHisto, opticalHisto);
        } else {
            this.hashBasedDuplicatesFinder.searchDuplicates(sequences, duplicationHisto, opticalHisto);
        }
    }
}

