/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool sorts the input SAM or BAM file by coordinate, queryname (QNAME), or some other property of the SAM record. The SortOrder of a SAM/BAM file is found in the SAM file header tag @HD in the field labeled SO.  <p> For a coordinate sorted SAM/BAM file, read alignments are sorted first by the reference sequence name (RNAME) field using the reference sequence dictionary (@SQ tag).  Alignments within these subgroups are secondarily sorted using the left-most mapping position of the read (POS).  Subsequent to this sorting scheme, alignments are listed arbitrarily.</p><p> For queryname-sorted alignments, the tool orders records deterministically by queryname field followed by record strand orientation flag, primary record flag, and secondary alignment flag. This ordering may change in future versions. </p><hr /><hr /><h4>Usage example:</h4><pre>java -jar picard.jar SortSam \\<br />      I=input.bam \\<br />      O=sorted.bam \\<br />      SORT_ORDER=coordinate</pre>", oneLineSummary="Sorts a SAM or BAM file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class SortSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Sorts a SAM or BAM file";
    static final String USAGE_DETAILS = "This tool sorts the input SAM or BAM file by coordinate, queryname (QNAME), or some other property of the SAM record. The SortOrder of a SAM/BAM file is found in the SAM file header tag @HD in the field labeled SO.  <p> For a coordinate sorted SAM/BAM file, read alignments are sorted first by the reference sequence name (RNAME) field using the reference sequence dictionary (@SQ tag).  Alignments within these subgroups are secondarily sorted using the left-most mapping position of the read (POS).  Subsequent to this sorting scheme, alignments are listed arbitrarily.</p><p> For queryname-sorted alignments, the tool orders records deterministically by queryname field followed by record strand orientation flag, primary record flag, and secondary alignment flag. This ordering may change in future versions. </p><hr /><hr /><h4>Usage example:</h4><pre>java -jar picard.jar SortSam \\<br />      I=input.bam \\<br />      O=sorted.bam \\<br />      SORT_ORDER=coordinate</pre>";
    @Argument(doc="Input BAM or SAM file to sort.", shortName="I")
    public File INPUT;
    @Argument(doc="Sorted BAM or SAM output file.", shortName="O")
    public File OUTPUT;
    @Argument(shortName="SO", doc="Sort order of output file. ")
    public SortOrder SORT_ORDER;
    private final Log log = Log.getInstance(SortSam.class);

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        reader.getFileHeader().setSortOrder(this.SORT_ORDER.getSortOrder());
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), false, this.OUTPUT);
        writer.setProgressLogger(new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Read");
        for (SAMRecord rec : reader) {
            writer.addAlignment(rec);
            progress.record(rec);
        }
        this.log.info("Finished reading inputs, merging and writing to output now.");
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }

    private static enum SortOrder implements CommandLineParser.ClpEnum
    {
        queryname("Sorts according to the readname. This will place read-pairs and other derived reads (secondary and supplementary) adjacent to each other. Note that the readnames are compared lexicographically, even though they may include numbers. In paired reads, Read1 sorts before Read2."),
        coordinate("Sorts primarily according to the SEQ and POS fields of the record. The sequence will sorted according to the order in the sequence dictionary, taken from from the header of the file. Within each reference sequence, the reads are sorted by the position. Unmapped reads whose mates are mapped will be placed near their mates. Unmapped read-pairs are placed after all the mapped reads and their mates."),
        duplicate("Sorts the reads so that duplicates reads are adjacent. Required that the mate-cigar (MC) tag is present. The resulting will be sorted by library, unclipped 5-prime position, orientation, and mate's unclipped 5-prime position.");

        private String description;

        private SortOrder(String description) {
            this.description = description;
        }

        public SAMFileHeader.SortOrder getSortOrder() {
            return SAMFileHeader.SortOrder.valueOf(this.name());
        }

        @Override
        public String getHelpDoc() {
            return this.description;
        }
    }
}

