/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TileTemplateRead;
import picard.util.MathUtil;

public class LanePhasingMetricsCollector {
    private final Map<TileTemplateRead, Float> medianPhasingMap;
    private final Map<TileTemplateRead, Float> medianPrePhasingMap;

    public LanePhasingMetricsCollector(Collection<Tile> laneTiles, boolean usePercentage) {
        TreeMap<TileTemplateRead, Float> medianPhasingMap = new TreeMap<TileTemplateRead, Float>();
        TreeMap<TileTemplateRead, Float> medianPrePhasingMap = new TreeMap<TileTemplateRead, Float>();
        CollectionUtil.MultiMap<TileTemplateRead, Float> phasingValues = new CollectionUtil.MultiMap<TileTemplateRead, Float>();
        CollectionUtil.MultiMap<TileTemplateRead, Float> prePhasingValues = new CollectionUtil.MultiMap<TileTemplateRead, Float>();
        for (Tile tile : laneTiles) {
            for (TileTemplateRead tileTemplateRead : tile.getPhasingMap().keySet()) {
                phasingValues.append(tileTemplateRead, tile.getPhasingMap().get((Object)tileTemplateRead));
                prePhasingValues.append(tileTemplateRead, tile.getPrePhasingMap().get((Object)tileTemplateRead));
            }
        }
        for (TileTemplateRead tileTemplateRead : phasingValues.keySet()) {
            medianPhasingMap.put(tileTemplateRead, Float.valueOf(LanePhasingMetricsCollector.median((Collection)phasingValues.get((Object)tileTemplateRead), usePercentage)));
            medianPrePhasingMap.put(tileTemplateRead, Float.valueOf(LanePhasingMetricsCollector.median((Collection)prePhasingValues.get((Object)tileTemplateRead), usePercentage)));
        }
        this.medianPhasingMap = Collections.unmodifiableMap(medianPhasingMap);
        this.medianPrePhasingMap = Collections.unmodifiableMap(medianPrePhasingMap);
    }

    public Map<TileTemplateRead, Float> getMedianPhasingMap() {
        return this.medianPhasingMap;
    }

    public Map<TileTemplateRead, Float> getMedianPrePhasingMap() {
        return this.medianPrePhasingMap;
    }

    private static float median(Collection<Float> phaseValues, boolean usePercentage) {
        double[] values = new double[phaseValues.size()];
        int i = 0;
        for (Float phaseValue : phaseValues) {
            values[i] = phaseValue.floatValue();
            ++i;
        }
        float median = (float)MathUtil.median(values);
        return usePercentage ? median * 100.0f : median;
    }
}

