/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.QualityUtil;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public class HaplotypeProbabilitiesFromContaminatorSequence
extends HaplotypeProbabilitiesFromSequence {
    public double contamination;
    double[][] likelihoodMap = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};

    public HaplotypeProbabilitiesFromContaminatorSequence(HaplotypeBlock haplotypeBlock, double contamination) {
        super(haplotypeBlock);
        assert (contamination <= 1.0);
        assert (contamination >= 0.0);
        this.contamination = contamination;
    }

    @Override
    public void addToProbs(Snp snp, byte base, byte qual) {
        boolean altAllele;
        this.assertSnpPartOfHaplotype(snp);
        if (base == snp.getAllele1()) {
            ++this.obsAllele1;
            altAllele = false;
        } else if (base == snp.getAllele2()) {
            ++this.obsAllele2;
            altAllele = true;
        } else {
            ++this.obsAlleleOther;
            return;
        }
        double pErr = QualityUtil.getErrorProbabilityFromPhredScore(qual);
        for (HaplotypeProbabilities.Genotype contGeno : HaplotypeProbabilities.Genotype.values()) {
            for (HaplotypeProbabilities.Genotype mainGeno : HaplotypeProbabilities.Genotype.values()) {
                double theta = 0.5 * ((1.0 - this.contamination) * (double)mainGeno.v + this.contamination * (double)contGeno.v);
                double[] dArray = this.likelihoodMap[contGeno.v];
                int n = mainGeno.v;
                dArray[n] = dArray[n] * ((altAllele ? theta : 1.0 - theta) * (1.0 - pErr) + (!altAllele ? theta : 1.0 - theta) * pErr);
            }
        }
    }

    private void updateLikelihoods() {
        double[] ll = new double[HaplotypeProbabilities.Genotype.values().length];
        for (HaplotypeProbabilities.Genotype contGeno : HaplotypeProbabilities.Genotype.values()) {
            ll[contGeno.v] = Math.log10(MathUtil.sum(MathUtil.multiply(this.getPriorProbablities(), this.likelihoodMap[contGeno.v])));
        }
        this.setLogLikelihoods(ll);
    }

    @Override
    public void merge(HaplotypeProbabilities other) {
        super.merge(other);
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesFromContaminatorSequence)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        HaplotypeProbabilitiesFromContaminatorSequence o = (HaplotypeProbabilitiesFromContaminatorSequence)other;
        if (o.contamination != this.contamination) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilitiesFromContaminatorSequence with the same contamination value.");
        }
        for (HaplotypeProbabilities.Genotype contGeno : HaplotypeProbabilities.Genotype.values()) {
            this.likelihoodMap[contGeno.v] = MathUtil.multiply(this.likelihoodMap[contGeno.v], o.likelihoodMap[contGeno.v]);
        }
    }

    @Override
    public double[] getLogLikelihoods() {
        this.updateLikelihoods();
        return super.getLogLikelihoods();
    }
}

