/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.ClusteredCrosscheckMetric;
import picard.fingerprint.CrosscheckMetric;
import picard.util.GraphUtils;

@CommandLineProgramProperties(summary="<h3>Summary</h3>\nClusters the results from a {@link CrosscheckFingerprints} run according to the LOD score. The resulting metric file can be used to assist diagnosing results from {@link CrosscheckFingerprints}. It clusters the connectivity graph between the different groups. Two groups are connected if they have a LOD score greater than the {@link #LOD_THRESHOLD}.\n \n<h3>Details</h3>The results of running {@link CrosscheckFingerprints} can be difficult to analyze, especially when many groups are related (meaning LOD greater than {@link #LOD_THRESHOLD}) in non-transitive manner (A is related to B, B is related to C, but A doesn't seem to be related to C.) {@link ClusterCrosscheckMetrics} clusters the metrics from {@link CrosscheckFingerprints} so that all the groups in a cluster are related to each other either directly, or indirectly (thus A, B and C would end up in one cluster.) Two samples can only be in two different clusters if all the samples from these two clusters do not get high LOD scores when compared to each other.\n\n<h3>Example</h3>\n<pre>\n    java -jar picard.jar ClusterCrosscheckMetrics \\\n             INPUT=sample.crosscheck_metrics \\\n             LOD_THRESHOLD=3 \\\n             OUTPUT=sample.clustered.crosscheck_metrics\n</pre>\n\nThe resulting file, consists of the {@link ClusteredCrosscheckMetric} class and contains the original crosscheck metric values, for groups that end-up in the same clusters (regardless of LOD score of each comparison). In addition it notes the {@link ClusteredCrosscheckMetric#CLUSTER} identifier and the size of the cluster (in {@link ClusteredCrosscheckMetric#CLUSTER_SIZE}.) Groups that do not have high LOD scores with any other group (including itself!) will not be included in the metric file. Note that cross-group comparisons are not included in the metric file. ", oneLineSummary="Clusters the results of a CrosscheckFingerprints run by LOD score", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class ClusterCrosscheckMetrics
extends CommandLineProgram {
    @Argument(shortName="I", doc="The cross-check metrics file to be clustered.")
    public File INPUT;
    @Argument(shortName="O", optional=true, doc="Output file to write metrics to. Will write to stdout if null.")
    public File OUTPUT;
    @Argument(shortName="LOD", doc="LOD score to be used as the threshold for clustering.")
    public double LOD_THRESHOLD = 0.0;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable(this.OUTPUT);
        }
        MetricsFile metricsFile = this.getMetricsFile();
        try {
            metricsFile.read(new FileReader(this.INPUT));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 1;
        }
        this.clusterMetrics(metricsFile.getMetrics()).write(this.OUTPUT);
        return 0;
    }

    private MetricsFile<ClusteredCrosscheckMetric, ?> clusterMetrics(List<CrosscheckMetric> metrics) {
        GraphUtils.Graph graph = new GraphUtils.Graph();
        metrics.stream().filter(metric -> metric.LOD_SCORE > this.LOD_THRESHOLD).forEach(metric -> {
            String lhsBy = metric.LEFT_GROUP_VALUE;
            String rhsBy = metric.RIGHT_GROUP_VALUE;
            graph.addEdge(lhsBy, rhsBy);
        });
        Map clusters = graph.cluster();
        Map<Integer, Set> collection = clusters.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(Map.Entry::getKey).collect(Collectors.toSet())));
        MetricsFile clusteredMetrics = this.getMetricsFile();
        for (Map.Entry<Integer, Set> cluster : collection.entrySet()) {
            clusteredMetrics.addAllMetrics(metrics.stream().filter(metric -> ((Set)cluster.getValue()).contains(metric.LEFT_GROUP_VALUE) && ((Set)cluster.getValue()).contains(metric.RIGHT_GROUP_VALUE)).map(metric -> {
                ClusteredCrosscheckMetric clusteredCrosscheckMetric = new ClusteredCrosscheckMetric((CrosscheckMetric)metric);
                clusteredCrosscheckMetric.CLUSTER = (Integer)cluster.getKey();
                clusteredCrosscheckMetric.CLUSTER_SIZE = ((Set)cluster.getValue()).size();
                return clusteredCrosscheckMetric;
            }).collect(Collectors.toSet()));
        }
        return clusteredMetrics;
    }
}

