/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CollectTargetedMetrics;
import picard.analysis.directed.TargetedPcrMetrics;
import picard.analysis.directed.TargetedPcrMetricsCollector;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Calculate PCR-related metrics from targeted sequencing data. <p>This tool calculates a set of PCR-related metrics from an aligned SAM or BAM file containing targeted sequencing data. It is appropriate for data produced with multiple small-target technologies including exome sequencing an custom amplicon panels such as the Illumina <a href='http://www.illumina.com/content/dam/illumina-marketing/documents/products/datasheets/datasheet_truseq_custom_amplicon.pdf'>TruSeq Custom Amplicon (TSCA)</a> kit.</p><p>If a reference sequence is provided, AT/GC dropout metrics will be calculated and the PER_TARGET_COVERAGE  option can be used to output GC content and mean coverage information for each target. The AT/GC dropout metrics indicate the degree of inadequate coverage of a particular region based on its AT or GC content. The PER_TARGET_COVERAGE option can be used to output GC content and mean sequence depth information for every target interval. </p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example</h4><pre>java -jar picard.jar CollectTargetedPcrMetrics \\<br />       I=input.bam \\<br />       O=output_pcr_metrics.txt \\<br />       R=reference.fasta \\<br />       AMPLICON_INTERVALS=amplicon.interval_list \\<br />       TARGET_INTERVALS=targets.interval_list </pre>Please see the metrics definitions page on <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#TargetedPcrMetrics'>TargetedPcrMetrics</a> for detailed explanations of the output metrics produced by this tool.<hr />", oneLineSummary="Calculate PCR-related metrics from targeted sequencing data. ", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CollectTargetedPcrMetrics
extends CollectTargetedMetrics<TargetedPcrMetrics, TargetedPcrMetricsCollector> {
    static final String USAGE_SUMMARY = "Calculate PCR-related metrics from targeted sequencing data. ";
    static final String USAGE_DETAILS = "<p>This tool calculates a set of PCR-related metrics from an aligned SAM or BAM file containing targeted sequencing data. It is appropriate for data produced with multiple small-target technologies including exome sequencing an custom amplicon panels such as the Illumina <a href='http://www.illumina.com/content/dam/illumina-marketing/documents/products/datasheets/datasheet_truseq_custom_amplicon.pdf'>TruSeq Custom Amplicon (TSCA)</a> kit.</p><p>If a reference sequence is provided, AT/GC dropout metrics will be calculated and the PER_TARGET_COVERAGE  option can be used to output GC content and mean coverage information for each target. The AT/GC dropout metrics indicate the degree of inadequate coverage of a particular region based on its AT or GC content. The PER_TARGET_COVERAGE option can be used to output GC content and mean sequence depth information for every target interval. </p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example</h4><pre>java -jar picard.jar CollectTargetedPcrMetrics \\<br />       I=input.bam \\<br />       O=output_pcr_metrics.txt \\<br />       R=reference.fasta \\<br />       AMPLICON_INTERVALS=amplicon.interval_list \\<br />       TARGET_INTERVALS=targets.interval_list </pre>Please see the metrics definitions page on <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#TargetedPcrMetrics'>TargetedPcrMetrics</a> for detailed explanations of the output metrics produced by this tool.<hr />";
    @Argument(shortName="AI", doc="An interval list file that contains the locations of the baits used.")
    public File AMPLICON_INTERVALS;
    @Argument(shortName="N", doc="Custom amplicon set name. If not provided it is inferred from the filename of the AMPLICON_INTERVALS intervals.", optional=true)
    public String CUSTOM_AMPLICON_SET_NAME;

    @Override
    protected IntervalList getProbeIntervals() {
        return IntervalList.fromFile(this.AMPLICON_INTERVALS);
    }

    @Override
    protected String getProbeSetName() {
        return this.CUSTOM_AMPLICON_SET_NAME != null ? this.CUSTOM_AMPLICON_SET_NAME : CollectTargetedMetrics.renderProbeNameFromFile(this.AMPLICON_INTERVALS);
    }

    @Override
    protected TargetedPcrMetricsCollector makeCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance) {
        return new TargetedPcrMetricsCollector(accumulationLevels, samRgRecords, refFile, perTargetCoverage, perBaseCoverage, targetIntervals, probeIntervals, probeSetName, nearProbeDistance, this.MINIMUM_MAPPING_QUALITY, this.MINIMUM_BASE_QUALITY, this.CLIP_OVERLAPPING_READS, true, this.INCLUDE_INDELS, this.COVERAGE_CAP, this.SAMPLE_SIZE);
    }
}

