/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Compare two metrics files.This tool compares the metrics and histograms generated from metric tools to determine if the generated results are identical.  This tool is useful to test and compare outputs when code changes are implemented. It is not meant for use by end-users of this toolkit.<br /><br />  The tool's output simply indicates whether two metrics files are equal or not equal. <br /> <h4>Usage example:</h4><pre>java -jar picard.jar CompareMetrics \\<br />      metricfile1.txt \\<br />      metricfile2.txt</pre><hr />", oneLineSummary="Compare two metrics files.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CompareMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Compare two metrics files.";
    static final String USAGE_DETAIL = "This tool compares the metrics and histograms generated from metric tools to determine if the generated results are identical.  This tool is useful to test and compare outputs when code changes are implemented. It is not meant for use by end-users of this toolkit.<br /><br />  The tool's output simply indicates whether two metrics files are equal or not equal. <br /> <h4>Usage example:</h4><pre>java -jar picard.jar CompareMetrics \\<br />      metricfile1.txt \\<br />      metricfile2.txt</pre><hr />";
    @PositionalArguments(minElements=2, maxElements=2)
    public List<File> metricsFiles;
    private static final Log log = Log.getInstance(CompareMetrics.class);

    @Override
    protected int doWork() {
        IOUtil.assertFilesAreReadable(this.metricsFiles);
        MetricsFile metricsA = new MetricsFile();
        MetricsFile metricsB = new MetricsFile();
        try {
            metricsA.read(new FileReader(this.metricsFiles.get(0)));
            metricsB.read(new FileReader(this.metricsFiles.get(1)));
            boolean areEqual = metricsA.areMetricsEqual(metricsB) && metricsA.areHistogramsEqual(metricsB);
            String status = areEqual ? "EQUAL" : "NOT EQUAL";
            log.info("Files " + this.metricsFiles.get(0) + " and " + this.metricsFiles.get(1) + "are " + status);
        }
        catch (Exception e) {
            throw new PicardException(e.getMessage());
        }
        return 0;
    }

    public static void main(String[] argv) {
        new CompareMetrics().instanceMainWithExit(argv);
    }
}

