/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.utils.Utils;

public class LegacyCommandLineArgumentParser
implements CommandLineParser {
    private static final int OPTION_COLUMN_WIDTH = 30;
    private static final int DESCRIPTION_COLUMN_WIDTH = 90;
    protected static final String BETA_PREFIX = "\n\n**BETA FEATURE - WORK IN PROGRESS**\n\n";
    protected static final String EXPERIMENTAL_PREFIX = "\n\n**EXPERIMENTAL FEATURE - USE AT YOUR OWN RISK**\n\n";
    private static final Boolean[] TRUE_FALSE_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] PACKAGES_WITH_WEB_DOCUMENTATION = new String[]{"picard"};
    private static final String defaultUsagePreamble = "Usage: program [options...]\n";
    private static final String defaultUsagePreambleWithPositionalArguments = "Usage: program [options...] [positional-arguments...]\n";
    private static final String OPTIONS_FILE = "OPTIONS_FILE";
    private static final String[][] FRAMEWORK_OPTION_DOC = new String[][]{{"--help", "-h", "Displays options specific to this tool."}, {"--stdhelp", "-H", "Displays options specific to this tool AND options common to all Picard command line tools."}, {"--version", null, "Displays program version."}};
    private static final Logger logger = LogManager.getLogger();
    private final Object callerOptions;
    private final String prefix;
    private final String prefixDot;
    private Field positionalArguments;
    private int minPositionalArguments;
    private int maxPositionalArguments;
    private final List<OptionDefinition> optionDefinitions = new ArrayList<OptionDefinition>();
    private final Map<String, OptionDefinition> optionMap = new HashMap<String, OptionDefinition>();
    private PrintStream messageStream;
    private String[] argv;
    private String programVersion = null;
    private String commandLine = "";
    private final CommandLineProgramProperties programProperties;
    private static final Map<String, String> htmlToText = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("&lt;", "<");
            this.put("&gt;", ">");
            this.put("&ge;", ">=");
            this.put("&le;", "<=");
            this.put("<p>", "\n");
        }
    };

    @Override
    public String getStandardUsagePreamble(Class<?> mainClass) {
        String preamble = "USAGE: " + mainClass.getSimpleName() + " [options]\n\n" + (this.hasWebDocumentation(mainClass) ? "Documentation: http://broadinstitute.github.io/picard/command-line-overview.html#" + mainClass.getSimpleName() + "\n\n" : "");
        if (mainClass.getAnnotation(ExperimentalFeature.class) != null) {
            return EXPERIMENTAL_PREFIX + preamble;
        }
        if (mainClass.getAnnotation(BetaFeature.class) != null) {
            return BETA_PREFIX + preamble;
        }
        return preamble;
    }

    public boolean hasWebDocumentation(Class<?> clazz) {
        for (String pkg : PACKAGES_WITH_WEB_DOCUMENTATION) {
            if (!clazz.getPackage().getName().startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public String getFaqLink() {
        return "To get help, see http://broadinstitute.github.io/picard/index.html#GettingHelp";
    }

    public LegacyCommandLineArgumentParser(Object callerOptions) {
        this(callerOptions, "");
    }

    private String getUsagePreamble() {
        String usagePreamble = "";
        usagePreamble = null != this.programProperties ? usagePreamble + this.programProperties.summary() : (this.positionalArguments == null ? usagePreamble + defaultUsagePreamble : usagePreamble + defaultUsagePreambleWithPositionalArguments);
        if (null != this.programVersion && 0 < this.programVersion.length()) {
            usagePreamble = usagePreamble + "Version: " + this.getVersion() + "\n";
        }
        return usagePreamble;
    }

    private LegacyCommandLineArgumentParser(Object callerOptions, String prefix) {
        this.callerOptions = callerOptions;
        this.prefix = prefix;
        this.prefixDot = prefix.isEmpty() ? "" : prefix + ".";
        this.createArgumentDefinitions(callerOptions);
        if (this.callerOptions.getClass().getAnnotation(ExperimentalFeature.class) != null && this.callerOptions.getClass().getAnnotation(BetaFeature.class) != null) {
            throw new CommandLineException.CommandLineParserInternalException("Features cannot be both Beta and Experimental");
        }
        this.programProperties = this.callerOptions.getClass().getAnnotation(CommandLineProgramProperties.class);
    }

    private void createArgumentDefinitions(Object callerArguments) {
        for (Field field : CommandLineParser.getAllFields(callerArguments.getClass())) {
            if (field.getAnnotation(Argument.class) != null && field.getAnnotation(ArgumentCollection.class) != null) {
                throw new CommandLineException.CommandLineParserInternalException("An Argument cannot be an argument collection: " + field.getName() + " in " + callerArguments.toString() + " is annotated as both.");
            }
            if (field.getAnnotation(PositionalArguments.class) != null) {
                this.handlePositionalArgumentAnnotation(field);
            }
            if (field.getAnnotation(Argument.class) != null) {
                this.handleOptionAnnotation(field, callerArguments);
            }
            if (field.getAnnotation(ArgumentCollection.class) == null) continue;
            try {
                field.setAccessible(true);
                this.createArgumentDefinitions(field.get(callerArguments));
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("should never reach here because we setAccessible(true)", e);
            }
        }
    }

    @Override
    public String getVersion() {
        return this.callerOptions.getClass().getPackage().getImplementationVersion();
    }

    @Override
    public String usage(boolean printCommon, boolean printHidden) {
        StringBuilder sb = new StringBuilder();
        if (!printHidden) {
            logger.warn("Hidden arguments are always printed in LegacyCommandLineArgumentParser");
        }
        if (this.prefix.isEmpty()) {
            String preamble = LegacyCommandLineArgumentParser.htmlUnescape(LegacyCommandLineArgumentParser.convertFromHtml(this.getStandardUsagePreamble(this.callerOptions.getClass()) + this.getUsagePreamble()));
            LegacyCommandLineArgumentParser.checkForNonASCII(preamble, "Tool description");
            sb.append(Utils.wrapParagraph(preamble, 120));
            sb.append("\nVersion: " + this.getVersion());
            sb.append("\n");
            sb.append("\n\nOptions:\n\n");
            for (String[] optionDoc : FRAMEWORK_OPTION_DOC) {
                this.printOptionParamUsage(sb, optionDoc[0], optionDoc[1], null, optionDoc[2]);
            }
        }
        if (!this.optionDefinitions.isEmpty()) {
            this.optionDefinitions.stream().filter(optionDefinition -> printCommon || !optionDefinition.isCommon).forEach(optionDefinition -> this.printOptionUsage(sb, (OptionDefinition)optionDefinition));
        }
        if (printCommon) {
            Field fileField;
            try {
                class OptionFileContainerForUsage {
                    public File optionFileContainer;

                    OptionFileContainerForUsage() {
                    }
                }
                fileField = OptionFileContainerForUsage.class.getField("optionFileContainer");
            }
            catch (NoSuchFieldException e) {
                throw new CommandLineException("Should never happen", e);
            }
            OptionDefinition optionsFileOptionDefinition = new OptionDefinition(fileField, null, OPTIONS_FILE, "", "File of OPTION_NAME=value pairs.  No positional parameters allowed.  Unlike command-line options, unrecognized options are ignored.  A single-valued option set in an options file may be overridden by a subsequent command-line option.  A line starting with '#' is considered a comment.", false, false, 0, Integer.MAX_VALUE, null, true, new String[0]);
            this.printOptionUsage(sb, optionsFileOptionDefinition);
        }
        return sb.toString();
    }

    static void checkForNonASCII(String documentationText, String location) {
        if (documentationText.matches("[^\\p{ASCII}]")) {
            throw new AssertionError((Object)("Non-ASCII character used in documentation (" + location + "). Only ASCII characters are allowed."));
        }
        if (Pattern.compile(".*&[a-zA-Z]*?;.*", 8).matcher(documentationText).find()) {
            throw new AssertionError((Object)("Non-ASCII character used in documentation (" + location + "). Only ASCII characters are allowed."));
        }
    }

    static String convertFromHtml(String textToConvert) {
        LinkedHashMap<String, String> regexps = new LinkedHashMap<String, String>();
        regexps.put("< *a *href=['\"](.*?)['\"] *>(.*?)</ *a *>", "$2 ($1)");
        regexps.put("< *a *href=['\"](.*?)['\"] *>(.*?)< *a */>", "$2 ($1)");
        regexps.put("</ *(br|p|table|h[1-4]|pre|hr|li|ul) *>", "\n");
        regexps.put("< *(br|p|table|h[1-4]|pre|hr|li|ul) */>", "\n");
        regexps.put("< *(p|table|h[1-4]|ul|pre) *>", "\n");
        regexps.put("<li>", " - ");
        regexps.put("</th>", "\t");
        regexps.put("<\\w*?>", "");
        return ((Stream)regexps.entrySet().stream().sequential()).reduce(textToConvert, (string, entrySet) -> string.replaceAll((String)entrySet.getKey(), (String)entrySet.getValue()), (a, b) -> b);
    }

    static String htmlUnescape(String str) {
        return ((Stream)htmlToText.entrySet().stream().sequential()).reduce(str, (string, entrySet) -> string.replace((CharSequence)entrySet.getKey(), (CharSequence)entrySet.getValue()), (a, b) -> b);
    }

    @Override
    public boolean parseArguments(PrintStream messageStream, String[] args) {
        this.argv = args;
        this.messageStream = messageStream;
        if (this.prefix.isEmpty()) {
            this.commandLine = this.callerOptions.getClass().getSimpleName();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                messageStream.append(this.usage(false, true));
                return false;
            }
            if (arg.equals("-H") || arg.equals("--stdhelp")) {
                messageStream.append(this.usage(true, true));
                return false;
            }
            if (arg.equals("--version")) {
                messageStream.println(this.getVersion());
                return false;
            }
            String[] pair = arg.split("=", 2);
            if (pair.length == 2) {
                if (pair[1].isEmpty() && i < args.length - 1) {
                    pair[1] = args[++i];
                }
                if (this.parseOption(pair[0], pair[1], false)) continue;
                messageStream.println();
                messageStream.append(this.usage(true, true));
                return false;
            }
            if (this.parsePositionalArgument(arg)) continue;
            messageStream.println();
            messageStream.append(this.usage(false, true));
            return false;
        }
        if (!this.checkNumArguments()) {
            messageStream.println();
            messageStream.append(this.usage(false, true));
            return false;
        }
        return true;
    }

    private boolean checkNumArguments() {
        StringBuilder commandLineString = new StringBuilder();
        try {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                String fullName = this.prefixDot + optionDefinition.name;
                StringBuilder mutextOptionNames = new StringBuilder();
                for (String mutexOption : optionDefinition.mutuallyExclusive) {
                    OptionDefinition mutextOptionDef = this.optionMap.get(mutexOption);
                    if (mutextOptionDef == null || !mutextOptionDef.hasBeenSet) continue;
                    mutextOptionNames.append(' ').append(this.prefixDot).append(mutextOptionDef.name);
                }
                if (optionDefinition.hasBeenSet && mutextOptionNames.length() > 0) {
                    this.messageStream.println("ERROR: Option '" + fullName + "' cannot be used in conjunction with option(s)" + mutextOptionNames.toString());
                    return false;
                }
                if (optionDefinition.isCollection) {
                    Collection c = (Collection)optionDefinition.field.get(optionDefinition.parent);
                    if (c.size() >= optionDefinition.minElements) continue;
                    this.messageStream.println("ERROR: Option '" + fullName + "' must be specified at least " + optionDefinition.minElements + " times.");
                    return false;
                }
                if (optionDefinition.optional || optionDefinition.hasBeenSet || optionDefinition.hasBeenSetFromParent || mutextOptionNames.length() != 0) continue;
                this.messageStream.print("ERROR: Option '" + fullName + "' is required");
                if (optionDefinition.mutuallyExclusive.isEmpty()) {
                    this.messageStream.println(".");
                } else {
                    this.messageStream.println(" unless any of " + optionDefinition.mutuallyExclusive + " are specified.");
                }
                return false;
            }
            if (this.positionalArguments != null) {
                Collection c = (Collection)this.positionalArguments.get(this.callerOptions);
                if (c.size() < this.minPositionalArguments) {
                    this.messageStream.println("ERROR: At least " + this.minPositionalArguments + " positional arguments must be specified.");
                    return false;
                }
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    Object posArg = iterator.next();
                    commandLineString.append(' ').append(posArg.toString());
                }
            }
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (!optionDefinition.hasBeenSet) continue;
                commandLineString.append(' ').append(this.prefixDot).append(optionDefinition.name).append('=').append(optionDefinition.field.get(optionDefinition.parent));
            }
            commandLineString.append("   ");
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (optionDefinition.hasBeenSet || optionDefinition.defaultValue.equals("null")) continue;
                commandLineString.append(' ').append(this.prefixDot).append(optionDefinition.name).append('=').append(optionDefinition.defaultValue);
            }
            this.commandLine = this.commandLine + commandLineString.toString();
            return true;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean parsePositionalArgument(String stringValue) {
        Collection c;
        Object value;
        if (this.positionalArguments == null) {
            this.messageStream.println("ERROR: Invalid argument '" + stringValue + "'.");
            return false;
        }
        try {
            value = this.constructFromString(this.getUnderlyingType(this.positionalArguments), stringValue);
        }
        catch (CommandLineException e) {
            this.messageStream.println("ERROR: " + e.getMessage());
            return false;
        }
        try {
            c = (Collection)this.positionalArguments.get(this.callerOptions);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (c.size() >= this.maxPositionalArguments) {
            this.messageStream.println("ERROR: No more than " + this.maxPositionalArguments + " positional arguments may be specified on the command line.");
            return false;
        }
        c.add(value);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOption(String key, String stringValue, boolean optionsFile) {
        Object value;
        if ((key = key.toUpperCase()).equals(OPTIONS_FILE)) {
            this.commandLine = this.commandLine + " " + this.prefix + OPTIONS_FILE + "=" + stringValue;
            return this.parseOptionsFile(stringValue);
        }
        OptionDefinition optionDefinition = this.optionMap.get(key);
        if (optionDefinition == null) {
            if (optionsFile) {
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + key);
            return false;
        }
        if (!optionDefinition.isCollection && optionDefinition.hasBeenSet && !optionDefinition.hasBeenSetFromOptionsFile) {
            this.messageStream.println("ERROR: Option '" + key + "' cannot be specified more than once.");
            return false;
        }
        try {
            if (stringValue.equals("null")) {
                if (!optionDefinition.optional) {
                    this.messageStream.println("ERROR: non-null value must be provided for '" + key + "'.");
                    return false;
                }
                value = null;
            } else {
                value = this.constructFromString(this.getUnderlyingType(optionDefinition.field), stringValue);
            }
        }
        catch (CommandLineException e) {
            this.messageStream.println("ERROR: " + e.getMessage());
            return false;
        }
        try {
            if (!optionDefinition.isCollection) {
                optionDefinition.field.set(optionDefinition.parent, value);
                optionDefinition.hasBeenSet = true;
                optionDefinition.hasBeenSetFromOptionsFile = optionsFile;
                return true;
            }
            Collection c = (Collection)optionDefinition.field.get(optionDefinition.parent);
            if (value == null) {
                c.clear();
            } else {
                if (c.size() >= optionDefinition.maxElements) {
                    this.messageStream.println("ERROR: Option '" + key + "' cannot be used more than " + optionDefinition.maxElements + " times.");
                    return false;
                }
                c.add(value);
            }
            optionDefinition.hasBeenSet = true;
            optionDefinition.hasBeenSetFromOptionsFile = optionsFile;
            return true;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean parseOptionsFile(String optionsFile) {
        return this.parseOptionsFile(optionsFile, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseOptionsFile(String optionsFile, boolean optionFileStyleValidation) {
        try (BufferedReader reader = new BufferedReader(new FileReader(optionsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] pair = line.split("=", 2);
                if (pair.length != 2) {
                    this.messageStream.println("Strange line in OPTIONS_FILE " + optionsFile + ": " + line);
                    this.messageStream.append(this.usage(true, true));
                    boolean bl = false;
                    return bl;
                }
                if (this.parseOption(pair[0], pair[1], optionFileStyleValidation)) continue;
                this.messageStream.println();
                this.messageStream.append(this.usage(true, true));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new CommandLineException("I/O error loading OPTIONS_FILE=" + optionsFile, e);
        }
    }

    private void printHtmlOptionUsage(PrintStream stream, OptionDefinition optionDefinition) {
        String type = this.getUnderlyingType(optionDefinition.field).getSimpleName();
        String optionLabel = this.prefixDot + optionDefinition.name + " (" + type + ")";
        stream.println("<tr><td>" + optionLabel + "</td><td>" + this.makeOptionDescription(optionDefinition) + "</td></tr>");
    }

    private void printOptionUsage(StringBuilder sb, OptionDefinition optionDefinition) {
        this.printOptionParamUsage(sb, optionDefinition.name, optionDefinition.shortName, this.getUnderlyingType(optionDefinition.field).getSimpleName(), this.makeOptionDescription(optionDefinition));
    }

    private void printOptionParamUsage(StringBuilder sb, String name, String shortName, String type, String optionDescription) {
        String optionLabel = this.prefixDot + name;
        if (type != null) {
            optionLabel = optionLabel + "=" + type;
        }
        sb.append(optionLabel);
        if (shortName != null && !shortName.isEmpty()) {
            sb.append("\n");
            optionLabel = this.prefixDot + shortName;
            if (type != null) {
                optionLabel = optionLabel + "=" + type;
            }
            sb.append(optionLabel);
        }
        int numSpaces = 30 - optionLabel.length();
        if (optionLabel.length() > 30) {
            sb.append("\n");
            numSpaces = 30;
        }
        this.printSpaces(sb, numSpaces);
        LegacyCommandLineArgumentParser.checkForNonASCII(optionDescription, name);
        String wrappedDescription = Utils.wrapParagraph(LegacyCommandLineArgumentParser.convertFromHtml(optionDescription), 90);
        String[] descriptionLines = wrappedDescription.split("\n");
        for (int i = 0; i < descriptionLines.length; ++i) {
            if (i > 0) {
                this.printSpaces(sb, 30);
            }
            sb.append(descriptionLines[i]);
            sb.append("\n");
        }
        sb.append("\n");
    }

    private String makeOptionDescription(OptionDefinition optionDefinition) {
        Object[] enumConstants;
        StringBuilder sb = new StringBuilder();
        if (!optionDefinition.doc.isEmpty()) {
            sb.append(optionDefinition.doc);
            sb.append("  ");
        }
        if (optionDefinition.optional) {
            sb.append("Default value: ");
            sb.append(optionDefinition.defaultValue);
            sb.append(". ");
            if (!optionDefinition.defaultValue.equals("null")) {
                sb.append("This option can be set to 'null' to clear the default value. ");
            }
        } else if (!optionDefinition.isCollection) {
            sb.append("Required. ");
        }
        if ((enumConstants = this.getUnderlyingType(optionDefinition.field).getEnumConstants()) == null && this.getUnderlyingType(optionDefinition.field) == Boolean.class) {
            enumConstants = TRUE_FALSE_VALUES;
        }
        if (enumConstants != null) {
            Boolean isClpEnum = enumConstants.length > 0 && enumConstants[0] instanceof CommandLineParser.ClpEnum;
            sb.append("Possible values: {");
            if (isClpEnum.booleanValue()) {
                sb.append('\n');
            }
            for (int i = 0; i < enumConstants.length; ++i) {
                if (i > 0 && !isClpEnum.booleanValue()) {
                    sb.append(", ");
                }
                sb.append(enumConstants[i].toString());
                if (!isClpEnum.booleanValue()) continue;
                sb.append(" (").append(((CommandLineParser.ClpEnum)enumConstants[i]).getHelpDoc()).append(")\n");
            }
            sb.append("} ");
        }
        if (optionDefinition.isCollection) {
            if (optionDefinition.minElements == 0) {
                if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                    sb.append("This option may be specified 0 or more times. ");
                } else {
                    sb.append("This option must be specified no more than ").append(optionDefinition.maxElements).append(" times. ");
                }
            } else if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                sb.append("This option must be specified at least ").append(optionDefinition.minElements).append(" times. ");
            } else {
                sb.append("This option may be specified between ").append(optionDefinition.minElements).append(" and ").append(optionDefinition.maxElements).append(" times. ");
            }
            if (!optionDefinition.defaultValue.equals("null")) {
                sb.append("This option can be set to 'null' to clear the default list. ");
            }
        }
        if (!optionDefinition.mutuallyExclusive.isEmpty()) {
            sb.append(" Cannot be used in conjuction with option(s)");
            for (String option : optionDefinition.mutuallyExclusive) {
                OptionDefinition mutextOptionDefinition = this.optionMap.get(option);
                if (mutextOptionDefinition == null) {
                    throw new CommandLineException("Invalid option definition in source code.  " + option + " doesn't match any known option.");
                }
                sb.append(' ').append(mutextOptionDefinition.name);
                if (mutextOptionDefinition.shortName.isEmpty()) continue;
                sb.append(" (").append(mutextOptionDefinition.shortName).append(')');
            }
        }
        return sb.toString();
    }

    private void printSpaces(StringBuilder sb, int numSpaces) {
        for (int i = 0; i < numSpaces; ++i) {
            sb.append(' ');
        }
    }

    private void handleOptionAnnotation(Field field, Object parent) {
        try {
            field.setAccessible(true);
            Argument optionAnnotation = field.getAnnotation(Argument.class);
            boolean isCollection = this.isCollectionField(field);
            if (isCollection) {
                if (optionAnnotation.maxElements() == 0) {
                    throw new CommandLineException.CommandLineParserInternalException("@Argument member " + field.getName() + "has maxElements = 0");
                }
                if (optionAnnotation.minElements() > optionAnnotation.maxElements()) {
                    throw new CommandLineException.CommandLineParserInternalException("In @Argument member " + field.getName() + ", minElements cannot be > maxElements");
                }
                if (field.get(parent) == null) {
                    this.createCollection(field, parent, "@Argument");
                }
            }
            if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
                throw new CommandLineException.CommandLineParserInternalException("@Argument member " + field.getName() + " must have a String ctor or be an enum");
            }
            OptionDefinition optionDefinition = new OptionDefinition(field, parent, field.getName(), optionAnnotation.shortName(), optionAnnotation.doc(), optionAnnotation.optional() || field.get(parent) != null, isCollection, optionAnnotation.minElements(), optionAnnotation.maxElements(), field.get(parent), optionAnnotation.common(), optionAnnotation.mutex());
            if (optionAnnotation.maxValue() != Double.POSITIVE_INFINITY) {
                logger.warn("Maximum allowed value for argument --{} is not enforced", optionDefinition.name);
            }
            if (optionAnnotation.minValue() != Double.NEGATIVE_INFINITY) {
                logger.warn("Minimum allowed value for argument --{} is not enforced", optionDefinition.name);
            }
            if (optionAnnotation.maxRecommendedValue() != Double.POSITIVE_INFINITY) {
                logger.warn("Maximum recommended value for argument --{} is not checked", optionDefinition.name);
            }
            if (optionAnnotation.minRecommendedValue() != Double.NEGATIVE_INFINITY) {
                logger.warn("Minimum recommended value for argument --{} is not checked", optionDefinition.name);
            }
            for (String option : optionAnnotation.mutex()) {
                OptionDefinition mutextOptionDef = this.optionMap.get(option);
                if (mutextOptionDef == null) continue;
                mutextOptionDef.mutuallyExclusive.add(field.getName());
            }
            if (this.optionMap.containsKey(optionDefinition.name)) {
                throw new CommandLineException.CommandLineParserInternalException(optionDefinition.name + " has already been used.");
            }
            if (!optionDefinition.shortName.isEmpty() && !optionDefinition.shortName.equals(optionDefinition.name)) {
                if (this.optionMap.containsKey(optionDefinition.shortName)) {
                    throw new CommandLineException.CommandLineParserInternalException(optionDefinition.shortName + " has already been used");
                }
                this.optionMap.put(optionDefinition.shortName, optionDefinition);
            }
            if (!this.optionMap.containsKey(optionDefinition.name)) {
                this.optionMap.put(optionDefinition.name, optionDefinition);
            }
            this.optionDefinitions.add(optionDefinition);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.CommandLineParserInternalException(field.getName() + " must have public visibility to have @Argument annotation");
        }
    }

    private void handlePositionalArgumentAnnotation(Field field) {
        if (this.positionalArguments != null) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalArguments cannot be used more than once in an option class.");
        }
        field.setAccessible(true);
        this.positionalArguments = field;
        if (!this.isCollectionField(field)) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalArguments must be applied to a Collection");
        }
        if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalParameters member " + field.getName() + "does not have a String ctor");
        }
        PositionalArguments positionalArgumentsAnnotation = field.getAnnotation(PositionalArguments.class);
        this.minPositionalArguments = positionalArgumentsAnnotation.minElements();
        this.maxPositionalArguments = positionalArgumentsAnnotation.maxElements();
        if (this.minPositionalArguments > this.maxPositionalArguments) {
            throw new CommandLineException.CommandLineParserInternalException("In @PositionalArguments, minElements cannot be > maxElements");
        }
        try {
            if (field.get(this.callerOptions) == null) {
                this.createCollection(field, this.callerOptions, "@PositionalParameters");
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.CommandLineParserInternalException(field.getName() + " must have public visibility to have @PositionalParameters annotation");
        }
    }

    @Override
    private boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void createCollection(Field field, Object callerOptions, String annotationType) throws IllegalAccessException {
        try {
            field.set(callerOptions, field.getType().newInstance());
        }
        catch (Exception ex) {
            try {
                field.set(callerOptions, new ArrayList());
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException.CommandLineParserInternalException("In collection " + annotationType + " member " + field.getName() + " cannot be constructed or auto-initialized with ArrayList, so collection must be initialized explicitly.");
            }
        }
    }

    @Override
    private Class<?> getUnderlyingType(Field field) {
        if (this.isCollectionField(field)) {
            ParameterizedType clazz = (ParameterizedType)field.getGenericType();
            Type[] genericTypes = clazz.getActualTypeArguments();
            if (genericTypes.length != 1) {
                throw new CommandLineException.CommandLineParserInternalException("Strange collection type for field " + field.getName());
            }
            return (Class)genericTypes[0];
        }
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    private boolean canBeMadeFromString(Class<?> clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        try {
            clazz.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Object constructFromString(Class clazz, String s) {
        try {
            if (clazz.isEnum()) {
                try {
                    return Enum.valueOf(clazz, s);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineException("'" + s + "' is not a valid value for " + clazz.getSimpleName() + ".", e);
                }
            }
            Constructor ctor = clazz.getConstructor(String.class);
            return ctor.newInstance(s);
        }
        catch (NoSuchMethodException e) {
            throw new CommandLineException("Cannot find string ctor for " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new CommandLineException("Abstract class '" + clazz.getSimpleName() + "'cannot be used for an option value type.", e);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException("String constructor for option value type '" + clazz.getSimpleName() + "' must be public.", e);
        }
        catch (InvocationTargetException e) {
            throw new CommandLineException("Problem constructing " + clazz.getSimpleName() + " from the string '" + s + "'.", e.getCause());
        }
    }

    public String[] getArgv() {
        return this.argv;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public Object getCallerOptions() {
        return this.callerOptions;
    }

    protected static final class OptionDefinition {
        final Field field;
        final Object parent;
        final String name;
        final String shortName;
        final String doc;
        final boolean optional;
        final boolean isCollection;
        final int minElements;
        final int maxElements;
        final String defaultValue;
        final boolean isCommon;
        boolean hasBeenSet = false;
        boolean hasBeenSetFromOptionsFile = false;
        boolean hasBeenSetFromParent = false;
        final Set<String> mutuallyExclusive;

        private OptionDefinition(Field field, Object parent, String name, String shortName, String doc, boolean optional, boolean collection, int minElements, int maxElements, Object defaultValue, boolean isCommon, String[] mutuallyExclusive) {
            this.field = field;
            this.parent = parent;
            this.name = name.toUpperCase();
            this.shortName = shortName.toUpperCase();
            this.doc = doc;
            this.optional = optional;
            this.isCollection = collection;
            this.minElements = minElements;
            this.maxElements = maxElements;
            this.defaultValue = defaultValue != null ? (this.isCollection && ((Collection)defaultValue).isEmpty() ? "null" : defaultValue.toString()) : "null";
            this.isCommon = isCommon;
            this.mutuallyExclusive = new HashSet<String>(Arrays.asList(mutuallyExclusive));
            if (this.field.getAnnotation(Hidden.class) != null) {
                logger.warn("Hidden annotation is not honored for --{}", this.name);
            }
        }
    }
}

