/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.interval.IntervalIndexCreator;
import htsjdk.tribble.index.interval.IntervalTreeIndex;
import htsjdk.tribble.index.linear.LinearIndex;
import htsjdk.tribble.index.linear.LinearIndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

public class IndexFactory {
    public static Index loadIndex(String indexFile) {
        return IndexFactory.loadIndex(indexFile, (Function<SeekableByteChannel, SeekableByteChannel>)null);
    }

    public static Index loadIndex(String indexFile, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) {
        try {
            return IndexFactory.loadIndex(indexFile, IndexFactory.indexFileInputStream(indexFile, indexWrapper));
        }
        catch (IOException ex) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", indexFile, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Index loadIndex(String source, InputStream inputStream) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, Defaults.NON_ZERO_BUFFER_SIZE);){
            Class<Index> indexClass = IndexType.getIndexType(bufferedInputStream).getIndexType();
            Constructor<Index> ctor = indexClass.getConstructor(InputStream.class);
            Index index = ctor.newInstance(bufferedInputStream);
            return index;
        }
        catch (TribbleException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            if (!(ex.getCause() instanceof EOFException)) throw new RuntimeException(ex);
            throw new TribbleException.CorruptedIndexFile("Index file is corrupted", source, ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static InputStream indexFileInputStream(String indexFile, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) throws IOException {
        InputStream inputStreamInitial = ParsingUtils.openInputStream(indexFile, indexWrapper);
        if (indexFile.endsWith(".gz")) {
            return new GZIPInputStream(inputStreamInitial);
        }
        if (indexFile.endsWith(".tbi")) {
            return new BlockCompressedInputStream(inputStreamInitial);
        }
        return inputStreamInitial;
    }

    public static LinearIndex createLinearIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createLinearIndex(inputFile, codec, LinearIndexCreator.DEFAULT_BIN_WIDTH);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> LinearIndex createLinearIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int binSize) {
        LinearIndexCreator indexCreator = new LinearIndexCreator(inputFile, binSize);
        return (LinearIndex)IndexFactory.createIndex(inputFile, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputFile, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createIntervalIndex(inputFile, codec, IntervalIndexCreator.DEFAULT_FEATURE_COUNT);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int featuresPerInterval) {
        IntervalIndexCreator indexCreator = new IntervalIndexCreator(inputFile, featuresPerInterval);
        return (IntervalTreeIndex)IndexFactory.createIndex(inputFile, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputFile, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createDynamicIndex(inputFile, codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type) {
        return IndexFactory.createIndex(inputFile, codec, type, null);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type, SAMSequenceDictionary sequenceDictionary) {
        switch (type) {
            case INTERVAL_TREE: {
                return IndexFactory.createIntervalIndex(inputFile, codec);
            }
            case LINEAR: {
                return IndexFactory.createLinearIndex(inputFile, codec);
            }
            case TABIX: {
                return IndexFactory.createTabixIndex(inputFile, codec, sequenceDictionary);
            }
        }
        throw new IllegalArgumentException("Unrecognized IndexType " + (Object)((Object)type));
    }

    @Deprecated
    public static void writeIndex(Index idx, File idxFile) throws IOException {
        idx.write(idxFile);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexBalanceApproach iba) {
        DynamicIndexCreator indexCreator = new DynamicIndexCreator(inputFile, iba);
        return IndexFactory.createIndex(inputFile, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputFile, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, TabixFormat tabixFormat, SAMSequenceDictionary sequenceDictionary) {
        TabixIndexCreator indexCreator = new TabixIndexCreator(sequenceDictionary, tabixFormat);
        return (TabixIndex)IndexFactory.createIndex(inputFile, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputFile, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, SAMSequenceDictionary sequenceDictionary) {
        return IndexFactory.createTabixIndex(inputFile, codec, codec.getTabixFormat(), sequenceDictionary);
    }

    private static Index createIndex(File inputFile, FeatureIterator iterator, IndexCreator creator) {
        Locatable lastFeature = null;
        HashMap<String, Feature> visitedChromos = new HashMap<String, Feature>(40);
        while (iterator.hasNext()) {
            String lastChr;
            long position = iterator.getPosition();
            Feature currentFeature = iterator.next();
            IndexFactory.checkSorted(inputFile, lastFeature, currentFeature);
            String curChr = currentFeature.getContig();
            String string = lastChr = lastFeature != null ? lastFeature.getContig() : null;
            if (!curChr.equals(lastChr)) {
                if (visitedChromos.containsKey(curChr)) {
                    String msg = "Input file must have contiguous chromosomes.";
                    msg = msg + " Saw feature " + IndexFactory.featToString((Feature)visitedChromos.get(curChr));
                    msg = msg + " followed later by " + IndexFactory.featToString((Feature)lastFeature);
                    msg = msg + " and then " + IndexFactory.featToString(currentFeature);
                    throw new TribbleException.MalformedFeatureFile(msg, inputFile.getAbsolutePath());
                }
                visitedChromos.put(curChr, currentFeature);
            }
            creator.addFeature(currentFeature, position);
            lastFeature = currentFeature;
        }
        long finalPosition = iterator.getPosition();
        iterator.close();
        return creator.finalizeIndex(finalPosition);
    }

    private static String featToString(Feature feature) {
        return feature.getContig() + ":" + feature.getStart() + "-" + feature.getEnd();
    }

    private static void checkSorted(File inputFile, Feature lastFeature, Feature currentFeature) {
        if (lastFeature != null && currentFeature.getStart() < lastFeature.getStart() && lastFeature.getContig().equals(currentFeature.getContig())) {
            throw new TribbleException.MalformedFeatureFile("Input file is not sorted by start position. \nWe saw a record with a start of " + currentFeature.getContig() + ":" + currentFeature.getStart() + " after a record with a start of " + lastFeature.getContig() + ":" + lastFeature.getStart(), inputFile.getAbsolutePath());
        }
    }

    static class FeatureIterator<FEATURE_TYPE extends Feature, SOURCE>
    implements CloseableTribbleIterator<Feature> {
        private final SOURCE source;
        private Feature nextFeature;
        private final FeatureCodec<FEATURE_TYPE, SOURCE> codec;
        private final File inputFile;
        private long cachedPosition;

        public FeatureIterator(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE> codec) {
            if (inputFile == null) {
                throw new IllegalArgumentException("FeatureIterator input file cannot be null");
            }
            this.codec = codec;
            this.inputFile = inputFile;
            try {
                if (IOUtil.hasBlockCompressedExtension(inputFile)) {
                    BlockCompressedInputStream bcs = FeatureIterator.initIndexableBlockCompressedStream(inputFile);
                    this.source = codec.makeIndexableSourceFromStream(bcs);
                } else {
                    PositionalBufferedStream ps = FeatureIterator.initIndexablePositionalStream(inputFile);
                    this.source = codec.makeIndexableSourceFromStream(ps);
                }
                this.codec.readHeader(this.source);
                this.readNextFeature();
            }
            catch (IOException e) {
                throw new TribbleException.InvalidHeader("Error reading header " + e.getMessage());
            }
        }

        private static PositionalBufferedStream initIndexablePositionalStream(File inputFile) {
            try {
                FileInputStream fileStream = new FileInputStream(inputFile);
                return new PositionalBufferedStream(fileStream);
            }
            catch (FileNotFoundException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputFile.getAbsolutePath());
            }
        }

        private static BlockCompressedInputStream initIndexableBlockCompressedStream(File inputFile) {
            try {
                if (!IOUtil.isBlockCompressed(inputFile.toPath(), true)) {
                    throw new TribbleException.MalformedFeatureFile("Input file is not in valid block compressed format.", inputFile.getAbsolutePath());
                }
                ISeekableStreamFactory ssf = SeekableStreamFactory.getInstance();
                SeekableStream seekableStream = ssf.getStreamFor(inputFile.getAbsolutePath());
                return new BlockCompressedInputStream(seekableStream);
            }
            catch (FileNotFoundException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Error initializing stream", inputFile.getAbsolutePath(), e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextFeature;
            this.readNextFeature();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : ((LocationAware)this.source).getPosition();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.codec.close(this.source);
        }

        private void readNextFeature() {
            this.cachedPosition = ((LocationAware)this.source).getPosition();
            try {
                this.nextFeature = null;
                while (this.nextFeature == null && !this.codec.isDone(this.source)) {
                    this.nextFeature = this.codec.decodeLoc(this.source);
                }
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), e);
            }
        }
    }

    public static enum IndexType {
        LINEAR(1480870228, LinearIndex.INDEX_TYPE, LinearIndexCreator.class, LinearIndex.class, LinearIndexCreator.DEFAULT_BIN_WIDTH),
        INTERVAL_TREE(1480870228, IntervalTreeIndex.INDEX_TYPE, IntervalIndexCreator.class, IntervalTreeIndex.class, IntervalIndexCreator.DEFAULT_FEATURE_COUNT),
        TABIX(TabixIndex.MAGIC_NUMBER, null, null, TabixIndex.class, -1);

        private final int magicNumber;
        private final Integer tribbleIndexType;
        private final Class<IndexCreator> indexCreatorClass;
        private final int defaultBinSize;
        private final Class<Index> indexType;

        public int getDefaultBinSize() {
            return this.defaultBinSize;
        }

        public IndexCreator getIndexCreator() {
            try {
                return this.indexCreatorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), e);
            }
        }

        public boolean canCreate() {
            return this.indexCreatorClass != null;
        }

        private IndexType(int magicNumber, Integer tribbleIndexType, Class creator, Class indexClass, int defaultBinSize) {
            this.magicNumber = magicNumber;
            this.tribbleIndexType = tribbleIndexType;
            this.indexCreatorClass = creator;
            this.indexType = indexClass;
            this.defaultBinSize = defaultBinSize;
        }

        public Integer getTribbleIndexType() {
            return this.tribbleIndexType;
        }

        public Class<Index> getIndexType() {
            return this.indexType;
        }

        public int getMagicNumber() {
            return this.magicNumber;
        }

        public static IndexType getIndexType(BufferedInputStream is) {
            int type;
            int magicNumber;
            is.mark(128);
            LittleEndianInputStream dis = new LittleEndianInputStream(is);
            try {
                magicNumber = dis.readInt();
                type = dis.readInt();
                is.reset();
                for (IndexType indexType : IndexType.values()) {
                    if (indexType.magicNumber != magicNumber || indexType.tribbleIndexType != null && indexType.tribbleIndexType != type) continue;
                    return indexType;
                }
            }
            catch (IOException e) {
                throw new TribbleException("Problem detecting index type", e);
            }
            throw new TribbleException.UnableToCreateCorrectIndexType(String.format("Unknown index type.  magic number: 0x%x; type %d", magicNumber, type));
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

