/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.interval.IntervalIndexCreator;
import htsjdk.tribble.index.linear.LinearIndexCreator;
import htsjdk.tribble.util.MathUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class DynamicIndexCreator
extends TribbleIndexCreator {
    IndexFactory.IndexBalanceApproach iba;
    Map<IndexFactory.IndexType, TribbleIndexCreator> creators;
    int longestFeatureLength = 0;
    long featureCount = 0L;
    MathUtils.RunningStat stats = new MathUtils.RunningStat();
    long basesSeen = 0L;
    Feature lastFeature = null;

    public DynamicIndexCreator(Path inputPath, IndexFactory.IndexBalanceApproach iba) {
        this.iba = iba;
        this.creators = this.getIndexCreators(inputPath, iba);
    }

    public DynamicIndexCreator(File inputFile, IndexFactory.IndexBalanceApproach iba) {
        this(IOUtil.toPath(inputFile), iba);
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        LinkedHashMap<Double, TribbleIndexCreator> mapping = DynamicIndexCreator.scoreIndexes((double)this.featureCount / (double)this.basesSeen, this.creators, this.longestFeatureLength, this.iba);
        TribbleIndexCreator creator = this.getMinIndex(mapping, this.iba);
        for (Map.Entry entry : this.properties.entrySet()) {
            creator.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        creator.addProperty("FEATURE_LENGTH_MEAN", String.valueOf(this.stats.mean()));
        creator.addProperty("FEATURE_LENGTH_STD_DEV", String.valueOf(this.stats.standardDeviation()));
        creator.addProperty("MEAN_FEATURE_VARIANCE", String.valueOf(this.stats.variance()));
        creator.addProperty("FEATURE_COUNT", String.valueOf(this.featureCount));
        return creator.finalizeIndex(finalFilePosition);
    }

    private Map<IndexFactory.IndexType, TribbleIndexCreator> getIndexCreators(Path inputPath, IndexFactory.IndexBalanceApproach iba) {
        HashMap<IndexFactory.IndexType, TribbleIndexCreator> creators = new HashMap<IndexFactory.IndexType, TribbleIndexCreator>();
        if (iba == IndexFactory.IndexBalanceApproach.FOR_SIZE) {
            LinearIndexCreator linearNormal = new LinearIndexCreator(inputPath, LinearIndexCreator.DEFAULT_BIN_WIDTH);
            creators.put(IndexFactory.IndexType.LINEAR, linearNormal);
            IntervalIndexCreator treeNormal = new IntervalIndexCreator(inputPath, IntervalIndexCreator.DEFAULT_FEATURE_COUNT);
            creators.put(IndexFactory.IndexType.INTERVAL_TREE, treeNormal);
        }
        if (iba == IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME) {
            LinearIndexCreator linearSmallBin = new LinearIndexCreator(inputPath, Math.max(200, LinearIndexCreator.DEFAULT_BIN_WIDTH / 4));
            creators.put(IndexFactory.IndexType.LINEAR, linearSmallBin);
            IntervalIndexCreator treeSmallBin = new IntervalIndexCreator(inputPath, Math.max(20, IntervalIndexCreator.DEFAULT_FEATURE_COUNT / 8));
            creators.put(IndexFactory.IndexType.INTERVAL_TREE, treeSmallBin);
        }
        return creators;
    }

    @Override
    public void addFeature(Feature f, long filePosition) {
        ++this.featureCount;
        this.basesSeen = this.lastFeature == null ? this.basesSeen + (long)f.getStart() : (f.getStart() - this.lastFeature.getStart() >= 0 ? this.basesSeen + (long)(f.getStart() - this.lastFeature.getStart()) : this.basesSeen + (long)f.getStart());
        this.longestFeatureLength = Math.max(this.longestFeatureLength, f.getEnd() - f.getStart() + 1);
        this.stats.push(this.longestFeatureLength);
        for (IndexCreator indexCreator : this.creators.values()) {
            indexCreator.addFeature(f, filePosition);
        }
        this.lastFeature = f;
    }

    protected static LinkedHashMap<Double, TribbleIndexCreator> scoreIndexes(double densityOfFeatures, Map<IndexFactory.IndexType, TribbleIndexCreator> indexes, int longestFeature, IndexFactory.IndexBalanceApproach iba) {
        if (indexes.size() < 1) {
            throw new IllegalArgumentException("Please specify at least one index to evaluate");
        }
        LinkedHashMap<Double, TribbleIndexCreator> scores = new LinkedHashMap<Double, TribbleIndexCreator>();
        for (Map.Entry<IndexFactory.IndexType, TribbleIndexCreator> entry : indexes.entrySet()) {
            if (entry.getValue() instanceof LinearIndexCreator) {
                double binSize = ((LinearIndexCreator)entry.getValue()).getBinSize();
                scores.put(binSize * densityOfFeatures * Math.ceil((double)longestFeature / binSize), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof IntervalIndexCreator) {
                scores.put(Double.valueOf(((IntervalIndexCreator)entry.getValue()).getFeaturesPerInterval()), entry.getValue());
                continue;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type, we don't have a scoring method for " + entry.getValue().getClass());
        }
        return scores;
    }

    private TribbleIndexCreator getMinIndex(Map<Double, TribbleIndexCreator> scores, IndexFactory.IndexBalanceApproach iba) {
        TreeMap<Double, TribbleIndexCreator> map = new TreeMap<Double, TribbleIndexCreator>();
        map.putAll(scores);
        TribbleIndexCreator idx = iba != IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME ? (TribbleIndexCreator)map.get(map.lastKey()) : (TribbleIndexCreator)map.get(map.firstKey());
        return idx;
    }

    @Override
    public void addProperty(String key, String value) {
        for (TribbleIndexCreator creator : this.creators.values()) {
            creator.addProperty(key, value);
        }
    }
}

