/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.AbstractFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.FastLineReader;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class FastaSequenceFile
extends AbstractFastaSequenceFile {
    private final boolean truncateNamesAtWhitespace;
    private final SeekableStream seekableStream;
    private FastLineReader in;
    private int sequenceIndex = -1;
    private final byte[] basesBuffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];

    public FastaSequenceFile(File file, boolean truncateNamesAtWhitespace) {
        this(IOUtil.toPath(file), truncateNamesAtWhitespace);
    }

    public FastaSequenceFile(Path path, boolean truncateNamesAtWhitespace) {
        super(path);
        this.truncateNamesAtWhitespace = truncateNamesAtWhitespace;
        this.seekableStream = null;
        this.in = new FastLineReader(IOUtil.openFileForReading(path));
    }

    public FastaSequenceFile(String source, SeekableStream seekableStream, SAMSequenceDictionary dictionary, boolean truncateNamesAtWhitespace) {
        super(null, source, dictionary);
        this.truncateNamesAtWhitespace = truncateNamesAtWhitespace;
        this.seekableStream = seekableStream;
        this.in = new FastLineReader(seekableStream);
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public ReferenceSequence nextSequence() {
        ++this.sequenceIndex;
        String name = this.readSequenceName();
        if (name == null) {
            this.close();
            return null;
        }
        int knownLength = this.sequenceDictionary == null ? -1 : this.sequenceDictionary.getSequence(this.sequenceIndex).getSequenceLength();
        byte[] bases = this.readSequence(knownLength);
        return new ReferenceSequence(name, this.sequenceIndex, bases);
    }

    @Override
    public void reset() {
        this.sequenceIndex = -1;
        if (this.getPath() != null) {
            this.in.close();
            this.in = new FastLineReader(IOUtil.openFileForReading(this.getPath()));
        } else {
            try {
                this.seekableStream.seek(0L);
            }
            catch (IOException e) {
                throw new SAMException("Problem seeking to start of stream during reset", e);
            }
            this.in = new FastLineReader(this.seekableStream);
        }
    }

    private String readSequenceName() {
        this.in.skipNewlines();
        if (this.in.eof()) {
            return null;
        }
        byte b = this.in.getByte();
        if (b != 62) {
            throw new SAMException("Format exception reading FASTA " + this.getSource() + ".  Expected > but saw chr(" + b + ") at start of sequence with index " + this.sequenceIndex);
        }
        byte[] nameBuffer = new byte[4096];
        int nameLength = 0;
        while (!this.in.eof()) {
            if ((nameLength += this.in.readToEndOfOutputBufferOrEoln(nameBuffer, nameLength)) == nameBuffer.length && !this.in.atEoln()) {
                throw new SAMException("Sequence name too long in FASTA " + this.getSource());
            }
            if (!this.in.atEoln()) continue;
        }
        if (nameLength == 0) {
            throw new SAMException("Missing sequence name in FASTA " + this.getSource());
        }
        String name = StringUtil.bytesToString(nameBuffer, 0, nameLength).trim();
        if (this.truncateNamesAtWhitespace) {
            name = SAMSequenceRecord.truncateSequenceName(name);
        }
        return name;
    }

    private byte[] readSequence(int knownLength) {
        byte[] bases = knownLength == -1 ? this.basesBuffer : new byte[knownLength];
        int sequenceLength = 0;
        while (!this.in.eof()) {
            boolean sawEoln = this.in.skipNewlines();
            if (this.in.eof() || sawEoln && this.in.peekByte() == 62) break;
            sequenceLength += this.in.readToEndOfOutputBufferOrEoln(bases, sequenceLength);
            while (sequenceLength > 0 && Character.isWhitespace(StringUtil.byteToChar(bases[sequenceLength - 1]))) {
                --sequenceLength;
            }
            if (sequenceLength == knownLength) {
                this.skipToEoln();
                break;
            }
            if (sequenceLength != bases.length) continue;
            byte[] tmp = new byte[bases.length * 2];
            System.arraycopy(bases, 0, tmp, 0, sequenceLength);
            bases = tmp;
        }
        if (sequenceLength != bases.length || bases == this.basesBuffer) {
            byte[] tmp = new byte[sequenceLength];
            System.arraycopy(bases, 0, tmp, 0, sequenceLength);
            bases = tmp;
        }
        return bases;
    }

    private void skipToEoln() {
        byte[] ignoreBuffer = new byte[1024];
        while (!this.in.eof() && !this.in.atEoln()) {
            this.in.readToEndOfOutputBufferOrEoln(ignoreBuffer, 0);
        }
    }
}

