/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.SubexponentialIntegerCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SubexponentialIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int offset;
    private final int k;

    SubexponentialIntegerEncoding(int offset, int k) {
        super(EncodingID.SUBEXPONENTIAL);
        if (k < 0) {
            throw new IllegalArgumentException("k parameter must not be negative");
        }
        this.offset = offset;
        this.k = k;
    }

    public static SubexponentialIntegerEncoding fromParams(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int offset = ITF8.readUnsignedITF8(buffer);
        int k = ITF8.readUnsignedITF8(buffer);
        return new SubexponentialIntegerEncoding(offset, k);
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.k, buffer);
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new SubexponentialIntegerCodec(coreBlockInputStream, coreBlockOutputStream, this.offset, this.k);
    }
}

