/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerParser {
    private final SAMFileHeader samFileHeader;

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records, ValidationStringency validationStringency) throws IllegalArgumentException, IllegalAccessException {
        if (container.isEOF()) {
            return Collections.emptyList();
        }
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice slice : container.slices) {
            records.addAll(this.getRecords(slice, container.header, validationStringency));
        }
        return records;
    }

    public Map<Integer, AlignmentSpan> getReferences(Container container, ValidationStringency validationStringency) throws IOException {
        HashMap<Integer, AlignmentSpan> containerSpanMap = new HashMap<Integer, AlignmentSpan>();
        for (Slice slice : container.slices) {
            ContainerParser.addAllSpans(containerSpanMap, this.getReferences(slice, container.header, validationStringency));
        }
        return containerSpanMap;
    }

    private static void addSpan(int seqId, int start, int span, int count, Map<Integer, AlignmentSpan> map) {
        if (map.containsKey(seqId)) {
            map.get(seqId).add(start, span, count);
        } else {
            map.put(seqId, new AlignmentSpan(start, span, count));
        }
    }

    private static Map<Integer, AlignmentSpan> addAllSpans(Map<Integer, AlignmentSpan> spanMap, Map<Integer, AlignmentSpan> addition) {
        for (Map.Entry<Integer, AlignmentSpan> entry : addition.entrySet()) {
            ContainerParser.addSpan(entry.getKey(), entry.getValue().getStart(), entry.getValue().getCount(), entry.getValue().getSpan(), spanMap);
        }
        return spanMap;
    }

    Map<Integer, AlignmentSpan> getReferences(Slice slice, CompressionHeader header, ValidationStringency validationStringency) throws IOException {
        HashMap<Integer, AlignmentSpan> spanMap = new HashMap<Integer, AlignmentSpan>();
        switch (slice.sequenceId) {
            case -1: {
                spanMap.put(-1, AlignmentSpan.UNMAPPED_SPAN);
                break;
            }
            case -2: {
                Map<Integer, AlignmentSpan> spans = slice.getMultiRefAlignmentSpans(header, validationStringency);
                ContainerParser.addAllSpans(spanMap, spans);
                break;
            }
            default: {
                ContainerParser.addSpan(slice.sequenceId, slice.alignmentStart, slice.alignmentSpan, slice.nofRecords, spanMap);
            }
        }
        return spanMap;
    }

    ArrayList<CramCompressionRecord> getRecords(ArrayList<CramCompressionRecord> records, Slice slice, CompressionHeader header, ValidationStringency validationStringency) throws IllegalArgumentException {
        String seqName = "*";
        switch (slice.sequenceId) {
            case -2: 
            case -1: {
                break;
            }
            default: {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(slice.sequenceId);
                seqName = sequence.getSequenceName();
            }
        }
        CramRecordReader reader = slice.createCramRecordReader(header, validationStringency);
        if (records == null) {
            records = new ArrayList(slice.nofRecords);
        }
        int prevStart = slice.alignmentStart;
        for (int i = 0; i < slice.nofRecords; ++i) {
            CramCompressionRecord record = new CramCompressionRecord();
            record.sliceIndex = slice.index;
            record.index = i;
            reader.read(record);
            if (record.sequenceId == slice.sequenceId) {
                record.sequenceName = seqName;
                record.sequenceId = slice.sequenceId;
            } else {
                record.sequenceName = record.sequenceId == -1 ? "*" : this.samFileHeader.getSequence(record.sequenceId).getSequenceName();
            }
            records.add(record);
            if (!header.APDelta) continue;
            record.alignmentStart = prevStart += record.alignmentDelta;
        }
        return records;
    }

    List<CramCompressionRecord> getRecords(Slice slice, CompressionHeader header, ValidationStringency validationStringency) throws IllegalArgumentException, IllegalAccessException {
        return this.getRecords(null, slice, header, validationStringency);
    }
}

