/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.digest.ContentDigests;
import htsjdk.samtools.cram.encoding.writer.CramRecordWriter;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.ExternalBlock;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFactory {
    private final SAMFileHeader samFileHeader;
    private int recordsPerSlice = 10000;
    private boolean preserveReadNames = true;
    private long globalRecordCounter = 0L;

    public ContainerFactory(SAMFileHeader samFileHeader, int recordsPerSlice) {
        this.samFileHeader = samFileHeader;
        this.recordsPerSlice = recordsPerSlice;
    }

    public Container buildContainer(List<CramCompressionRecord> records) {
        return this.buildContainer(records, null);
    }

    Container buildContainer(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) {
        boolean coordinateSorted = this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate;
        CompressionHeader header = new CompressionHeaderFactory().build(records, substitutionMatrix, coordinateSorted);
        header.readNamesIncluded = this.preserveReadNames;
        ArrayList<Slice> slices = new ArrayList<Slice>();
        Container container = new Container();
        container.header = header;
        container.nofRecords = records.size();
        container.globalRecordCounter = this.globalRecordCounter;
        container.bases = 0L;
        container.blockCount = 0;
        long lastGlobalRecordCounter = container.globalRecordCounter;
        for (int i = 0; i < records.size(); i += this.recordsPerSlice) {
            List<CramCompressionRecord> sliceRecords = records.subList(i, Math.min(records.size(), i + this.recordsPerSlice));
            Slice slice = ContainerFactory.buildSlice(sliceRecords, header);
            slice.globalRecordCounter = lastGlobalRecordCounter;
            lastGlobalRecordCounter += (long)slice.nofRecords;
            container.bases += slice.bases;
            slices.add(slice);
            if (container.sequenceId != -1 || slice.sequenceId == -1) continue;
            container.sequenceId = slice.sequenceId;
        }
        container.slices = slices.toArray(new Slice[slices.size()]);
        ContainerFactory.calculateAlignmentBoundaries(container);
        this.globalRecordCounter += (long)records.size();
        return container;
    }

    private static void calculateAlignmentBoundaries(Container container) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Slice s : container.slices) {
            if (s.sequenceId == -1) continue;
            start = Math.min(start, s.alignmentStart);
            end = Math.max(end, s.alignmentStart + s.alignmentSpan);
        }
        if (start < Integer.MAX_VALUE) {
            container.alignmentStart = start;
            container.alignmentSpan = end - start;
        }
    }

    private static Slice buildSlice(List<CramCompressionRecord> records, CompressionHeader header) {
        HashMap<Integer, ByteArrayOutputStream> externalBlockMap = new HashMap<Integer, ByteArrayOutputStream>();
        for (int id : header.externalIds) {
            externalBlockMap.put(id, new ByteArrayOutputStream());
        }
        Slice slice = new Slice();
        slice.nofRecords = records.size();
        int minAlStart = Integer.MAX_VALUE;
        int maxAlEnd = 0;
        slice.sequenceId = records.get((int)0).sequenceId;
        ContentDigests hasher = ContentDigests.create(ContentDigests.ALL);
        for (CramCompressionRecord record : records) {
            slice.bases += (long)record.readLength;
            hasher.add(record);
            if (slice.sequenceId == -2) continue;
            if (slice.sequenceId != record.sequenceId) {
                slice.sequenceId = -2;
                continue;
            }
            if (record.alignmentStart == 0) continue;
            minAlStart = Math.min(record.alignmentStart, minAlStart);
            maxAlEnd = Math.max(record.getAlignmentEnd(), maxAlEnd);
        }
        slice.sliceTags = hasher.getAsTags();
        if (slice.sequenceId == -2 || minAlStart == Integer.MAX_VALUE) {
            slice.alignmentStart = -1;
            slice.alignmentSpan = 0;
        } else {
            slice.alignmentStart = minAlStart;
            slice.alignmentSpan = maxAlEnd - minAlStart + 1;
        }
        try {
            ByteArrayOutputStream bitBAOS = new ByteArrayOutputStream();
            Object object = null;
            try (DefaultBitOutputStream bitOutputStream2 = new DefaultBitOutputStream(bitBAOS);){
                CramRecordWriter writer = new CramRecordWriter(bitOutputStream2, externalBlockMap, header, slice.sequenceId);
                writer.writeCramCompressionRecords(records, slice.alignmentStart);
                bitOutputStream2.close();
                slice.coreBlock = Block.createRawCoreDataBlock(bitBAOS.toByteArray());
            }
            catch (Throwable bitOutputStream2) {
                object = bitOutputStream2;
                throw bitOutputStream2;
            }
            finally {
                if (bitBAOS != null) {
                    if (object != null) {
                        try {
                            bitBAOS.close();
                        }
                        catch (Throwable bitOutputStream2) {
                            ((Throwable)object).addSuppressed(bitOutputStream2);
                        }
                    } else {
                        bitBAOS.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        slice.external = new HashMap<Integer, Block>();
        for (Integer contentId : externalBlockMap.keySet()) {
            if (contentId == 0) {
                throw new CRAMException("Valid Content ID required.  Given: " + contentId);
            }
            ExternalCompressor compressor = header.externalCompressors.get(contentId);
            byte[] rawContent = ((ByteArrayOutputStream)externalBlockMap.get(contentId)).toByteArray();
            ExternalBlock externalBlock = new ExternalBlock(compressor.getMethod(), contentId, compressor.compress(rawContent), rawContent.length);
            slice.external.put(contentId, externalBlock);
        }
        return slice;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }
}

