/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class SamFiles {
    private static final Log LOG = Log.getInstance(SamFiles.class);

    public static File findIndex(File samFile) {
        Path path = SamFiles.findIndex(IOUtil.toPath(samFile));
        return path == null ? null : path.toFile();
    }

    public static Path findIndex(Path samPath) {
        Path indexPath = SamFiles.lookForIndex(samPath);
        if (indexPath == null) {
            return SamFiles.unsymlinkAndLookForIndex(samPath);
        }
        return indexPath;
    }

    private static Path unsymlinkAndLookForIndex(Path samPath) {
        try {
            Path canonicalSamPath = samPath.toRealPath(new LinkOption[0]);
            Path canonicalIndexPath = SamFiles.lookForIndex(canonicalSamPath);
            if (canonicalIndexPath != null) {
                LOG.warn("The index file " + canonicalIndexPath.toAbsolutePath() + " was found by resolving the canonical path of a symlink: " + samPath.toAbsolutePath() + " -> " + samPath.toRealPath(new LinkOption[0]));
            }
            return canonicalIndexPath;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Path lookForIndex(Path samPath) {
        Path indexPath;
        String fileName = samPath.getFileName().toString();
        if (fileName.endsWith(".bam")) {
            String bai = fileName.substring(0, fileName.length() - ".bam".length()) + ".bai";
            indexPath = samPath.resolveSibling(bai);
            if (Files.isRegularFile(indexPath, new LinkOption[0])) {
                return indexPath;
            }
        } else if (fileName.endsWith(".cram")) {
            String crai = fileName.substring(0, fileName.length() - ".cram".length()) + ".crai";
            indexPath = samPath.resolveSibling(crai);
            if (Files.isRegularFile(indexPath, new LinkOption[0])) {
                return indexPath;
            }
            indexPath = samPath.resolveSibling(fileName + ".crai");
            if (Files.isRegularFile(indexPath, new LinkOption[0])) {
                return indexPath;
            }
        }
        if (Files.isRegularFile(indexPath = samPath.resolveSibling(fileName + ".bai"), new LinkOption[0])) {
            return indexPath;
        }
        return null;
    }
}

