/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl;

import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.NativeLibrary;

public final class IntelGKLUtils
implements NativeLibrary {
    private static final Logger logger = LogManager.getLogger(IntelGKLUtils.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_utils";
    private static boolean initialized = false;
    private static final String TEST_RESOURCES_PATH = System.getProperty("user.dir") + "/src/test/resources/";
    private static final String TEST_RESOURCES_ABSPATH = new File(TEST_RESOURCES_PATH).getAbsolutePath() + "/";

    @Override
    public synchronized boolean load(File tempDir) {
        if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
            return false;
        }
        if (!initialized) {
            initialized = true;
        }
        return true;
    }

    public static String pathToTestResource(String filename) {
        return TEST_RESOURCES_ABSPATH + filename;
    }

    public boolean getFlushToZero() {
        return this.getFlushToZeroNative();
    }

    public void setFlushToZero(boolean value) {
        this.setFlushToZeroNative(value);
    }

    public boolean isAvxSupported() {
        return this.isAvxSupportedNative();
    }

    public boolean isAvx2Supported() {
        return this.isAvx2SupportedNative();
    }

    public boolean isAvx512Supported() {
        return this.isAvx512SupportedNative();
    }

    public int getAvailableOmpThreads() {
        return this.getAvailableOmpThreadsNative();
    }

    private native boolean getFlushToZeroNative();

    private native void setFlushToZeroNative(boolean var1);

    private native boolean isAvxSupportedNative();

    private native boolean isAvx2SupportedNative();

    private native boolean isAvx512SupportedNative();

    private native int getAvailableOmpThreadsNative();
}

