#!/usr/bin/python3

from argparse import ArgumentParser
import os

def parse_names_dmp_file(names_dmp):
    names = {}
    with open(names_dmp, 'rt') as in_file:
        for line in in_file:
            lsplit = line.strip().split("|")
            names[lsplit[1].strip()] = lsplit[0].strip()

    return names

def add_taxids(kreport, output_file, names):
    with open(output_file, 'wt') as f_out:
        with open(kreport, 'rt') as in_file:
            for line in in_file:
                lsplit = line.strip().split("\t")
                lsplit[4] = names[lsplit[5]]
                new_line = "\t".join(lsplit)
                f_out.write( new_line + "\n")


def main():

    parser = ArgumentParser("")
    parser.add_argument('-k', '--kreport', required=True,
                        help='kraken report file')
    parser.add_argument('-o', '--output_file', required=True,
                        help="kraken report output file")
    parser.add_argument('-n', '--names_dmp', required=True,
                        help="names map file from ncbi taxonomy")
                       
    args = parser.parse_args()

    if not os.path.exists(args.kreport):
        print("[Error] The given kraken report file does not exist: " + args.kreport)
        return
    
    if not os.path.exists(args.names_dmp):
        print("[Error] The given names.dmp file does not exist: " + args.names_dmp)
        return

    
    names = parse_names_dmp_file(args.names_dmp)
    add_taxids(args.kreport, args.output_file, names)




if __name__ == "__main__":
    main()