#pragma once

#include <utility>
#include <cstdlib>
#include <cassert>
#include <cmath>
#include <iostream>

namespace hixf::threshold
{
    // Matrix that stores minimal matching ratios for each combination of kmer size and read accuracy
    // rows correspond to read accuracies 80% <= x <= 100%
    // columns represent kmer sizes 12,14,...,30
    double matching_ratios[21][10] = {
                {0.552077, 0.195989, 0.151428, 0.118475, 0.0946177, 0.0797244, 0.0604658, 0.0480255, 0.0367569, 0.0252911}, 
                {0.552385, 0.207533, 0.161204, 0.127368, 0.103704,  0.0881939, 0.0689396, 0.0556991, 0.044185,  0.0298818},
                {0.552239, 0.220393, 0.17382,  0.139866, 0.113736,  0.0966358, 0.0783558, 0.0639223, 0.0523452, 0.0389549},
                {0.552682, 0.236329, 0.188152, 0.152267, 0.126191,  0.106106,  0.0876917, 0.0730642, 0.0621864, 0.0489249},
                {0.553172, 0.254091, 0.202686, 0.165344, 0.137087,  0.116649,  0.098822,  0.0831266, 0.0703342, 0.0582562},
                {0.553716, 0.271183, 0.219848, 0.181959, 0.152163,  0.130048,  0.110622,  0.0942414, 0.0810792, 0.0688187},
                {0.554532, 0.292154, 0.240059, 0.199738, 0.168952,  0.144956,  0.122726,  0.105878,  0.0940805, 0.0777557},
                {0.557957, 0.313553, 0.260912, 0.220014, 0.186567,  0.16101,   0.137399,  0.119867,  0.10453,   0.0900014},
                {0.563925, 0.338316, 0.283689, 0.2401,   0.206963,  0.179541,  0.155347,  0.135128,  0.121575,  0.104741},
                {0.568519, 0.364594, 0.310373, 0.267578, 0.231083,  0.20088,   0.174376,  0.153111,  0.139339,  0.120042},
                {0.579726, 0.395595, 0.338947, 0.295287, 0.258713,  0.22876,   0.200759,  0.175309,  0.161306,  0.139616},
                {0.599258, 0.430241, 0.371291, 0.325596, 0.289651,  0.257329,  0.228011,  0.201799,  0.186956,  0.164794},
                {0.611572, 0.468953, 0.410482, 0.363923, 0.325828,  0.293046,  0.26167,   0.235216,  0.216716,  0.192162},
                {0.624341, 0.510411, 0.452122, 0.407016, 0.370022,  0.334601,  0.303413,  0.275232,  0.254563,  0.227871},
                {0.655724, 0.555245, 0.498564, 0.453201, 0.416285,  0.381883,  0.352291,  0.322556,  0.299739,  0.271481},
                {0.694872, 0.608367, 0.552085, 0.509395, 0.471692,  0.437803,  0.405938,  0.377117,  0.354352,  0.325132},
                {0.742071, 0.669034, 0.613738, 0.57366,  0.539215,  0.50832,   0.476855,  0.449152,  0.42683,   0.397277},
                {0.795543, 0.733694, 0.68341,  0.647737, 0.617382,  0.588448,  0.56083,   0.533714,  0.514757,  0.486399},
                {0.853121, 0.802585, 0.763169, 0.733734, 0.708902,  0.684331,  0.660171,  0.637633,  0.621567,  0.596993},
                {0.918163, 0.882314, 0.854479, 0.835831, 0.819643,  0.804269,  0.788526,  0.771895,  0.763059,  0.742114},
                {1.0,      1.0,      1.0,      1.0,      1.0,       1.0,       1.0,       1.0,       1.0,       1.0}
                                    };

    double get_min_syncmer_match_ratio(size_t kmer_size, double error_rate)
    {
        assert(kmer_size % 2 == 0);
        assert(kmer_size >= 10u);
        assert(kmer_size <= 30u);
        assert(error_rate >= 0);
        assert(error_rate <= 0.2);

        //size_t accuracy = static_cast<size_t>((1.0 - error_rate) * 100.0);
        size_t row_index = ceil((1.0 - error_rate) * 100.0 - 80.0);//accuracy - 80;
        size_t col_index = kmer_size - 10 - ((kmer_size-10)/2) - 1;
        return matching_ratios[row_index][col_index];
    }

}