library(monocle3)
library(ggplot2)

genotypes=c('Control','FSHD','DEL5','all')

for (g in genotypes){
    #expression_matrix_ori <- readRDS(url("https://depts.washington.edu:/trapnell-lab/software/monocle3/celegans/data/packer_embryo_expression.rds"))
    #cell_metadata_ori <- readRDS(url("https://depts.washington.edu:/trapnell-lab/software/monocle3/celegans/data/packer_embryo_colData.rds"))
    #gene_annotation_ori <- readRDS(url("https://depts.washington.edu:/trapnell-lab/software/monocle3/celegans/data/packer_embryo_rowData.rds"))
    #write.csv(cell_metadata_ori, 'D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/original_data/r_based_analysis_data/MNC_myotube_pseudotime/ori_meta.csv')

    expression_matrix <- read.csv(paste('D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/original_data/r_based_analysis_data/MNC_myotube_pseudotime/combined_count_',g,'.csv',sep=''))
    cell_metadata <- read.csv(paste('D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/original_data/r_based_analysis_data/MNC_myotube_pseudotime/combined_meta_',g,'.csv',sep=''))
    gene_annotation <- read.csv(paste('D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/original_data/r_based_analysis_data/MNC_myotube_pseudotime/gene_anno_',g,'.csv',sep=''))

    ncol_curr=140
    # rearrange count data
    coln<-colnames(expression_matrix)
    rown<-rownames(expression_matrix)
    coln<-replace(coln,93,"NKX2-5")
    expression_matrix=matrix(unlist(expression_matrix), ncol = ncol_curr)
    expression_matrix=t(expression_matrix[,1:ncol_curr])
    rownames(expression_matrix) <- coln[1:ncol_curr] # use colname for rows as countData is transposed
    colnames(expression_matrix) <- rown # use colname for rows as countData is transposed
    print("finish count")

    # rearrange meta data
    coln<-colnames(cell_metadata)
    rown<-rownames(cell_metadata)
    cell_metadata=matrix(unlist(cell_metadata), ncol = 6)
    cell_metadata=cell_metadata[,1:6]
    colnames(cell_metadata) <- coln[1:6] # use colname for rows as countData is transposed
    rownames(cell_metadata) <- rown
    print("finish meta data")

    # rearrange gene_anno data
    coln<-colnames(gene_annotation)
    rown<-gene_annotation$id
    gene_annotation=matrix(unlist(gene_annotation), ncol = 3)
    gene_annotation=gene_annotation[,1:3]
    colnames(gene_annotation) <- coln[1:3] # use colname for rows as countData is transposed
    rownames(gene_annotation) <- rown # use colname for rows as countData is transposed
    print("finish gene anno")

    # generate dataset
    cds <- new_cell_data_set(expression_matrix,
                            cell_metadata = cell_metadata,
                            gene_metadata = gene_annotation)
    print("dataset gen finish")

    # preprocess
    cds <- preprocess_cds(cds, num_dim = 50)
    cds <- align_cds(cds, alignment_group = "batch")
    print("preprocess fin")

    # reduce dim
    cds <- reduce_dimension(cds)
    #cds <- reduce_dimension(cds,preprocess_method="PCA")
    pdf(paste("D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/results/MNC_myotube_pseudotime/figures/reduce_dim_",g,".pdf",sep=""))
    print(plot_cells(cds, label_groups_by_cluster=FALSE,  color_cells_by = "cell.type"))
    dev.off()

    pdf(paste("D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/results/MNC_myotube_pseudotime/figures/reduce_dim_genotype_",g,".pdf",sep=""))
    print(plot_cells(cds, label_groups_by_cluster=FALSE,  color_cells_by = "genotype"))
    dev.off()

    print("reduce dim fin")

    # get UMAP coor
    #umap<-plot_cells(cds, label_groups_by_cluster=FALSE,  color_cells_by = "genotype")
    #point<-ggplot_build(umap)$[["plot"]][["data"]]
    #write.csv(point,'D:/Kyoko_Xiangduo_MERFISH_cell_cluster/umap.csv')
    
    # cluster
    cds <- cluster_cells(cds)
    pdf(paste("D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/results/MNC_myotube_pseudotime/figures/cluster_",g,".pdf",sep=""))
    print(plot_cells(cds, color_cells_by = "partition"))
    dev.off()
    print("cluster fin")

    # GENES
    #c("NEB", "TTN", "MYH8", "MYH3","CCNA1",	"KHDC1L","KLF17","RBP7","RFPL4B","SLC34A2","ZNF280A","ZNF296","ZNF705G","ZSCAN4")
    pdf(paste("D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/results/MNC_myotube_pseudotime/figures/GENES_",g,".pdf",sep=""))
    p<-plot_cells(cds, genes=c("NEB", "TTN", "MYH8", "MYH3","CCNA1","ZSCAN4"),label_cell_groups=FALSE,label_leaves=FALSE,label_branch_points=FALSE)
    print(p)
    dev.off()
    # learn trajectory graph
    cds <- learn_graph(cds)
    pdf(paste("D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/results/MNC_myotube_pseudotime/figures/trajectory_",g,".pdf",sep=""))
    print(plot_cells(cds,
            color_cells_by = "cell.type",
            label_groups_by_cluster=FALSE,
            label_leaves=FALSE,
            label_branch_points=FALSE))
    dev.off()
    print("learn_graph fin")

    # order cells in pseudotime

    #get_earliest_principal_node <- function(cds, time_bin="130-170"){
    #  cell_ids <- which(colData(cds)[, "embryo.time.bin"] == time_bin)
    
    #  closest_vertex <-
    #  cds@principal_graph_aux[["UMAP"]]$pr_graph_cell_proj_closest_vertex
    #  closest_vertex <- as.matrix(closest_vertex[colnames(cds), ])
    #  root_pr_nodes <-
    #  igraph::V(principal_graph(cds)[["UMAP"]])$name[as.numeric(names
    #  (which.max(table(closest_vertex[cell_ids,]))))]
    
    #  root_pr_nodes
    #}

}
cds <- order_cells(cds)
pdf(paste("D:/Kyoko_Xiangduo_MERFISH_cell_cluster_project/dataset_pooled/results/MNC_myotube_pseudotime/figures/ordered_trajectory2_",g,".pdf",sep=""))
print(plot_cells(cds,
           color_cells_by = "pseudotime",
           label_cell_groups=FALSE,
           label_leaves=FALSE,
           label_branch_points=FALSE,
           graph_label_size=1.5))
dev.off()


print("order_traj fin")