
function TranscriptOverlay_Kyoto_cellpose_fastInPolygon_110222(fname, transcriptName,savName,geneListIn,offset,offset_scale,magRange,maskk,colorIn,cellSizeRange,loadOverlay)
    %% process transcript
    [Imgo,xy_dat,dat]=DAPI_preprocess(fname,transcriptName,9.26,-1,offset,offset_scale);
%     Imgo1=Imgo/max(Imgo1(:));
    if length(size(Imgo))==1
        Imgo1=adapthisteq(double(Imgo)/max(double(Imgo(:))));
    else
        Imgo1=double(Imgo)./max(double(Imgo(:)));
    end
    %% overall overlay
    
    t1=tic;
    if ~isempty(dat)
        geneList=table2cell(dat(:,{'gene'}));
    else
        geneList={'ACTA1', 'ACTN2', 'ADAM15', 'ADAM19', 'ANKLE2', 'ATF6B', 'BAK1', 'BAX', 'BEX1', 'BGN', 'BMP1', 'BMP4', 'CASQ2', 'CCL2', 'CCNA1', 'CCNB1', 'CCND2', 'CCNL1', 'CD70', 'CDK1', 'CITED2', 'COL18A1', 'COL4A1', 'COL4A2', 'COL5A1', 'COL5A2', 'COL5A3', 'COL6A1', 'COL6A2', 'COL8A1', 'CXCL1', 'DBET', 'DCTN1', 'DNMT1', 'DNMT3B', 'DUXA', 'DUXAP8', 'DUXB', 'EIF2AK3', 'FADD', 'FAS', 'FN1', 'GDF15', 'GREM1', 'GSN', 'H3.Y', 'HOXA11', 'HSPA5', 'HSPA6', 'HSPB8', 'HYOU1', 'IFIT3', 'IFITM1', 'IFITM2', 'IGFBP3', 'ITGA10', 'ITGA11', 'KDM4E', 'KHDC1L', 'KLF17', 'KLHL41', 'LAMA5', 'LAMB1', 'LAMB2', 'LAMC1', 'LEUTX', 'LMOD2', 'LOX', 'LOXL1', 'LOXL2', 'LOXL3', 'LRATD1', 'LRIF1', 'MEF2C', 'MFAP4', 'MMP14', 'MMP19', 'MMP2', 'MSC', 'MTCH1', 'MYDGF', 'MYH3', 'MYH6', 'MYH7', 'MYH8', 'MYL2', 'MYL3', 'MYMX', 'MYOG', 'MYOM3', 'NCOA3', 'NEB', 'NKX2-5', 'NOG', 'PCOLCE', 'PDGFA', 'PNRC2', 'PRAMEF12', 'PRAMEF19', 'PRAMEF20', 'PRR15', 'PRR32', 'PTAR1', 'PTX3', 'RBBP6', 'RBP7', 'RFPL1', 'RFPL2', 'RFPL4B', 'RPN2', 'SEC31A', 'SERPINE1', 'SERPINE2', 'SLC14A1', 'SLC34A2', 'SLC38A1', 'SLC9A3R2', 'SMCHD1', 'SMPX', 'SOX4', 'SOX9', 'TAF11L11', 'TCAP', 'TGFB1', 'TGFBR1', 'TIMP3', 'TNNI2', 'TRIM72', 'TTN', 'TWIST1', 'VMO1', 'WFS1', 'WIPI1', 'XBP1', 'YIF1A', 'ZNF280A', 'ZNF296', 'ZNF596', 'ZNF705G', 'ZSCAN4'};
    end
    
    if isempty(geneListIn)
        geneListIn=unique(geneList);
    end
    
    if length(geneListIn)>4
        if ~isempty(colorIn)
            colorVal=colorIn;
        else
            colorVal=distinguishable_colors(length(geneListIn)+1);
            colorVal(4,:)=[]; % no black color
        end
       
    else
        if ~isempty(colorIn)
            colorVal=colorIn;
        else
            colorVal=distinguishable_colors(length(geneListIn)+1);
        end
    end
        
    close;
    if ~loadOverlay
        transcriptOverlay=zeros(size(Imgo1,1),size(Imgo1,2),3);
        maskk1=zeros(size(Imgo1,1),size(Imgo1,2));
        for i=1:1:length(geneListIn)
            geneIdx=contains(geneList,geneListIn{i});
            coorList=round(xy_dat(geneIdx,:));
            coorList(coorList(:,2)>size(Imgo1,1),2)=size(Imgo1,1);
            coorList(coorList(:,1)>size(Imgo1,2),1)=size(Imgo1,2);
            for j=1:size(coorList,1)
                transcriptOverlay(coorList(j,2),coorList(j,1),:)=colorVal(i,:);
                maskk1(coorList(j,2),coorList(j,1))=1;
            end
        end
    else
        transcriptOverlay=imread(savName);
        transcriptOverlay=imresize(transcriptOverlay,[size(Imgo1,1),size(Imgo1,2)]); % usually this step will not functional
        maskk1=rgb2gray(transcriptOverlay)>0;
    end 
    
    [ph]=fileparts(savName);
    mkdir(ph);
    %% all overlay, across sample %%%%%%%%%%%%%%%%%%%%%
    Imgo1t=Imgo1;
    if length(size(Imgo1t))==3
        for u=1:3
            t=squeeze(Imgo1t(:,:,u));
            t(logical(maskk1))=0;
            Imgo1t(:,:,u)=t;
        end
        Imgo_3=squeeze(Imgo1t(:,:,2)); % for overlay, no need for multi colors as it is ugly
    else
        Imgo1t(logical(maskk1))=0;
        Imgo_3=double(cat(3,Imgo1t,Imgo1t,Imgo1t));
    end
    
    Imgo_3=transcriptOverlay;
    Imgo_3=double(Imgo_3)/max(double(Imgo_3(:)));
    Imgo_3=uint8(Imgo_3*255);
    imagesc(Imgo_3)

    imwrite(Imgo_3,savName)
    
    Imgo_3_spec=transcriptOverlay;
    Imgo_3=double(Imgo_3)/max(double(Imgo_3(:)));
    [ph,fn]=fileparts(savName);
    imwrite(Imgo_3_spec,[ph,'\',fn,'_overlayDump.tif']);
    
    Imgo_31=double(cat(3,squeeze(Imgo1t(:,:,2)),squeeze(Imgo1t(:,:,2)),squeeze(Imgo1t(:,:,2))));
    Imgo_31=Imgo_31/max(Imgo_31(:))+double(transcriptOverlay)/max(max(max(double(transcriptOverlay))));
    Imgo_31=uint8(Imgo_31*255);
    
    [ph,fn]=fileparts(savName);
    imwrite(Imgo_31,[ph,'\',fn,'_withStaining.tif']);    
    
    disp('overall overlay finished');
    toc(t1);
    %% magnify
    t1=tic;
    gListVal=geneListIn;
    Imgo_3=uint8(double(Imgo_3)*255/max(double(Imgo_3(:))));
    
    if ~isempty(magRange) % magRange={[xlim],[ylim]}
        
        close;
        
        rectangleMask=uint8(Imgo_3*0);
        for i=magRange{1}(1):magRange{1}(2)
            for u=-2:2
                rectangleMask(magRange{2}(1),i+u,1)=255;
                rectangleMask(magRange{2}(2),i+u,1)=255;
            end
        end
        for i=magRange{2}(1):magRange{2}(2)
            for u=-2:2
                rectangleMask(i+u,magRange{1}(1),1)=255;
                rectangleMask(i+u,magRange{1}(2),1)=255;
            end
        end
        
        %%%%%%%%%%%%%% no gene
        Imgo1t1=uint8(Imgo1*255)+rectangleMask;
        imagesc(Imgo1t1);hold on
        xlim(magRange{1})
        ylim(magRange{2})
        axis ij
        [ph,fn]=fileparts(savName);
        set(gcf,'renderer','painters');
        saveas(gcf,[ph,'\',fn,'_mag_no_gene.eps'],'epsc')
        saveas(gcf,[ph,'\',fn,'_mag_no_gene.tif'])
        close;
        
        %%%%%%%%%%%%%% all gene
        Imgo_4=Imgo_3+rectangleMask;
        imagesc(Imgo_4);hold on
        
        imwrite(Imgo_4,savName);
        close
        
        figure('position',[0,0,1000,1000])
        imagesc(Imgo_3);
        hold on;

        xlim(magRange{1})
        ylim(magRange{2})
        colormap(gray)
        axis ij
        [ph,fn]=fileparts(savName);
        set(gcf,'renderer','painters');
        saveas(gcf,[ph,'\',fn,'_mag.eps'],'epsc')
        saveas(gcf,[ph,'\',fn,'_mag.tif'])
    end
    disp('mag part')
    toc(t1);
    
    %% cell boundary
    if ~isempty(maskk)
        close;
        
        figure('position',[0,0,1000,1000]);hold on
        
        % get cell bound
        if ~iscell(maskk) % image mask, extract cellBounds
            if isstring(maskk)
                load(maskk); % maskk suppose to be the name of cellBoudn file
                if ~exist('cellBound2','var')
                    cellBound2=cellBound;
                end
                cellBound2=MERFISH_cellBound_cleaning(cellBound2,cellSizeRange,xy_dat);
                cellBound1=cellBound2;
            else
                tic;
                cellBound=cellpose_mask2cellBound(maskk);
                toc;
%                 cellBound1=MERFISH_cellBound_cleaning(cellBound,cellSizeRange,xy_dat);
                cellBound2=MERFISH_find_cellBound_in_magRange_cellPose(cellBound,magRange);
            end
        else
            cellBound2=maskk;
        end
        
        % plot overall in cell transcript
        if length(cellBound2)>1
            cellBound3=cellBound2;
        else 
            cellBound3=cellBound2{1};
        end
        inCellTranscriptOverlay_all=MERFISH_in_cell_transcript_cellpose_imgVer_color(transcriptOverlay,Imgo,cellBound3);
        imwrite(inCellTranscriptOverlay_all,[ph,'\',fn,'_inAllCell_OverlayAll.tif'])
        
        % plot overall in cell transcript, mag
        if ~isempty(magRange)
            figure('position',[0,0,1000,1000])
            imagesc(inCellTranscriptOverlay_all);
            hold on;
    
            xlim(magRange{1})
            ylim(magRange{2})
            colormap(gray)
            axis ij
            set(gcf,'renderer','painters');
            saveas(gcf,[ph,'\',fn,'_inAllCell_OverlayAll_mag.eps'],'epsc')
            saveas(gcf,[ph,'\',fn,'_inAllCell_OverlayAll_mag.tif'])
            close;
        end

        % plot in-cell transcript 
        if ~isempty(magRange)
            if length(cellBound2)>1
                cellBound2={cellBound2};
            end
            inCellTranscriptOverlay=MERFISH_in_cell_transcript_cellpose_imgVer(transcriptOverlay,cellBound2{1},magRange);
            imagesc(inCellTranscriptOverlay);
            hold on;

            for j=1:length(cellBound2)
                for k=1:length(cellBound2{j})
                    bdTemp=cellBound2{j}{k};
                    if ~isempty(bdTemp)              
                        plot(bdTemp(:,1),bdTemp(:,2),'color','k','lineWidth',1);
                    end
                end
            end

            xlim(magRange{1})
            ylim(magRange{2})
            axis off;grid off
            [ph,fn]=fileparts(savName);
            set(gcf,'renderer','painters');
            saveas(gcf,[ph,'\',fn,'_inCell.eps'],'epsc')
            saveas(gcf,[ph,'\',fn,'_inCell.tif'])
            imwrite(inCellTranscriptOverlay,[ph,'\',fn,'_inCellOverlayAll.tif'])
            close

            % cell boundary with image
            figure('position',[0,0,1000,1000]);hold on
            imagesc(Imgo1);%colormap(gray)
            for j=1:length(cellBound2)
                for k=1:length(cellBound2{j})
                    bdTemp=cellBound2{j}{k};
                    if ~isempty(bdTemp)   
                        plot(bdTemp(:,1),bdTemp(:,2),'color','r','lineWidth',1);
                    end
                end
            end

            xlim(magRange{1})
            ylim(magRange{2})
            % axis ij
            [ph,fn]=fileparts(savName);
            set(gcf,'renderer','painters');
            saveas(gcf,[ph,'\',fn,'_cellBoundIllustration.eps'],'epsc')
    %         save([ph,'\',fn,'_cellBoundCellpose.mat'],'cellBound','cellBound1','cellBound2')
        end
    end
    disp('cell bound part')
    disp(['time for mag generation and cell bound gen: ',num2str(toc(t1))]);
%     close;