function [DAPIo,xy_dat,dat]=DAPI_preprocess(DAPIname,fname,micron2pix,scalee,offSet,offset_scale)

%% 1. separate corresponding DAPI

tic;
if ~iscell(DAPIname)||length(DAPIname)==1
    img=imread(DAPIname);
else
    img=imread(DAPIname{1});
    img=imresize(img,0.1);

    imgStack=zeros(size(img,1),size(img,2),length(DAPIname));
    imgStack(:,:,1)=img;

    for i=2:length(DAPIname)
        imgt=imresize(imread(DAPIname{i}),0.1);
        imgStack(:,:,i)=imgt;
    end

    img=max(imgStack,[],3);
end
scalee1=scalee;
if scalee==-1
    scalee=1;
    scalee1=0.1;
end
if ~isempty(fname)
    dat=readtable(fname);

    xy_dat=[];
    try
        xy_dat=table2array(dat(:,{'global_x','global_y'}));    
    catch
        xy_dat=table2array(dat(:,{'center_x','center_y'}));   
    end

    if isempty(xy_dat)
        error('coordination data has to contain [global_x,global_y] or [cener_x,center_y]');
    end

    xy_dat=(xy_dat-min(xy_dat,[],1)+1)*micron2pix*scalee1; % align left top acorner with original img
        
    xy_dat=[(xy_dat(:,1)+offSet(1))*offset_scale(1),(xy_dat(:,2)+offSet(2))*offset_scale(2)];
    xy_dat(xy_dat(:,1)>size(img,2),1)=size(img,2);
    xy_dat(xy_dat(:,2)>size(img,1),2)=size(img,1);

    % if strcmp(fname,'D:\MERFISH_5XFAD_TERM_experiment\all_8_datasets_040322\original_data\cluster_data_cellType\case_4_data.csv')
    %     xy_dat=[xy_dat(:,1)*1.005+80,xy_dat(:,2)*0.93];
    % end
    % xy_dat_cell={ones(size(xy_dat,1),1),ones(size(xy_dat,1),1),xy_dat(:,1),xy_dat(:,2)};
    % manualAdjustmentGUI(img,xy_dat_cell);
%     bbox=round([1,1,max(xy_dat_1(:,1)),max(xy_dat_1(:,2))]);

%     DAPIo=img(bbox(2):bbox(4),bbox(1):bbox(3),:);
    DAPIo=img;

    DAPIo=imresize(DAPIo,scalee);
else
    DAPIo=imresize(img,scalee);
    xy_dat=[];
    dat=[];
end
disp('finish preprocessing');
toc;

