
import plotly.graph_objects as go
import plotly.express as px
import numpy as np

def volcano_plot(df):

    # Calculate log2FC and -logP values
    for col in df.columns:
        df['log2FC'+col] = np.log2(df[col])
        df['-log10pval'+col] = np.log10(df[col]) * (-1)

    # Plot volcano plot
    fig = go.Figure()
    for col in df.columns:
        trace = go.Scatter(x=df['log2FC'+col],
                            y=df['-log10pval'+col],
                            mode='markers',
                            name=col,
                            hovertext=list(df.index))
        
        fig.add_trace(trace)
    
    fig.update_layout(title='Volcano plot for seronegatives')
    fig.show()

    # Plot volcano plot with text
    # fig_d1 = px.scatter(df, x='log2FC_1d', y='negative_log_pval_1d', text=df.index)
    # fig_d1.update_traces(textposition='top center')
    # fig_d1.update_layout(title_text='Volcano plot for seronegatives (day 1)')
   #  fig_d1.show()