import os
import numpy as np
import pandas as pd
from matplotlib import path
def data_trim_with_boundary(DATA_DIR,SAV_DIR,samples,boundaries):

    i = 0

    for sample in samples:
        print(sample)
        fdata = os.path.join(DATA_DIR, '{}_cell_by_gene.csv'.format(sample))
        fmeta = os.path.join(DATA_DIR, '{}_cell_metadata.csv'.format(sample))

        # metadata
        meta = pd.read_csv(fmeta, index_col=0)

        # gmat
        data = pd.read_csv(fdata, index_col=0)
        #data=data.drop(columns='Unnamed: 0.1')
        data = data.drop(data.filter(regex='^Blank-').columns, axis=1) # blank removal mechanism, here
        data = data.drop(data.filter(regex='^Blank_').columns, axis=1) # remove possible blanks which is becoming Blank_ during matlab processing
        cell_cov = data.sum(axis=1)
        meta['cell_cov'] = cell_cov

        # cell_cov
        if i == 0:
            genes = data.columns.values
            genes=np.sort(genes)
        else:
            genes1=data.columns.values
            genes1=np.sort(genes1)
            t=genes == genes1
            #print([i for i, x in enumerate(t) if not x])
            #print([genes[i] for i, x in enumerate(t) if not x])
            #print([genes1[i] for i, x in enumerate(t) if not x])
            #assert np.all(genes == data.columns)

        # record
        i += 1
        
        # gey meta xy. adjustment already done in assignment phase
        xy=meta.loc[:,['center_x','center_y']]
        xy1=xy.values
       # xym=xy.min(axis=0)
        #xy1=xy-xym[None,:]
        #xy1=xy1*transformFactor*shrinkFactor
        #xy1=xy1+offset[None,:]

        # in boundary analysis
        bd=boundaries.get(sample)
        p=path.Path(bd)
        inPolygonIdx=p.contains_points(xy1)

        # trim data
        meta=meta[inPolygonIdx]
        data=data.loc[meta.index]

        outdata = os.path.join(SAV_DIR, '{}_cell_by_gene.csv'.format(sample))
        outmeta = os.path.join(SAV_DIR, '{}_cell_metadata.csv'.format(sample))
        meta.to_csv(outmeta)
        data.to_csv(outdata)
    