#!/usr/bin/env python
# coding: utf-8

# In[1]:


import pyglet
from pyglet.window import key
from pyglet.window import mouse
from pyglet import shapes
from pyglet import image
from pyglet import sprite

# In[2]:


def mouse_select_region(filepath=[],margin=0,scale_factor=[1,1]):
    

    if not filepath:
        print("please provide the image file")
        return

    pic = image.load(filepath)
    pic_sprite = sprite.Sprite(pic)
    
    batch = pyglet.graphics.Batch()

    # utility variables
    lines=[]
    mouse_pos=[]
    mouse_pos_show=[]
    mouse_pos_show_ori=[]
    
    original_width=pic_sprite.width
    original_height=pic_sprite.height

    scale_additional_x=1000/original_width
    scale_additional_y=800/original_height
    viewpoint_x=0
    viewpoint_y=0

    pic_sprite.scale_x=scale_additional_x
    pic_sprite.scale_y=scale_additional_y

    window = pyglet.window.Window(width=1000, height=800)

    @window.event
    def on_draw():
        window.clear()
        pic_sprite.draw()
        batch.draw()
        print('Redrawing.')

    @window.event
    def on_key_press(symbol, modifiers):
        
        if symbol == key.BACKSPACE:
            if lines: # make sure it is not empty
                print('remove last click')
                lines.pop()
                mouse_pos.pop()
                mouse_pos_show.pop()
                mouse_pos_show_ori.pop()
                on_draw()
            
        elif symbol == key.ENTER:
            print('The enter key was pressed.')
            window.close()
            pyglet.app.exit()

    @window.event
    def on_mouse_press(x, y, button, modifiers):
        if button == mouse.LEFT:
            coor=[(x/scale_additional_x-margin)*scale_factor[0],(y/scale_additional_y-margin)*scale_factor[1]]
            mouse_pos.append(coor)
            mouse_pos_show.append([x,y]) # coors in 30 margin saved image
            mouse_pos_show_ori.append([x/scale_additional_x,y/scale_additional_y]) # coors in 30 margin saved image

            if len(mouse_pos_show)>1:
                lines.append(shapes.Line(mouse_pos_show[len(mouse_pos_show)-1][0], mouse_pos_show[len(mouse_pos_show)-1][1], mouse_pos_show[len(mouse_pos_show)-2][0], mouse_pos_show[len(mouse_pos_show)-2][1], width=3,batch=batch,color=[255,0,0]))
            else:
                lines.append(shapes.Circle(x, y, 4, color=[255,0,0],batch=batch))
                
            on_draw()
            
            print(coor)

    pyglet.app.run()
    
    return mouse_pos, mouse_pos_show_ori, mouse_pos_show




