import h5py

from shapely.geometry import Point
from shapely.geometry import Polygon
import numpy as np
import os
from os import listdir
from os.path import isfile, join
from scipy.sparse import coo_array
from scipy.sparse import save_npz
import multiprocessing as mp
mypath='/cncm/Lab/Kevin_public/merfishTest/Trem2_AD_Raw/region0/cell_boundaries/'
files = [f for f in listdir(mypath) if isfile(join(mypath, f))]
mask=np.empty((0,2), int)

def add_cell_to_mask(filename):
    
    file=h5py.File(filename,'r')
    keys=file['featuredata'].keys()
    keys=list(keys)
    curr_mask=[]
    for j in range(len(keys)):
        keys1=list(file['featuredata'][keys[j]].keys())
        curr_mask.append([])
        for l in range(len(keys1)):
            try:
                temp=[]
                coord=file['featuredata'][keys[j]][keys1[l]]['p_0']['coordinates']
                
                poly=Polygon(coord[0])
                mins=np.min(coord[0],0)
                maxs=np.max(coord[0],0)
                points=[[i,j] for i in range(int(np.floor(mins[0]))-1,int(np.ceil(maxs[0]))+1) for j in range(int(np.floor(mins[1]))-1,int(np.ceil(maxs[1]))+1)]
                point1=[Point(points[i]) for i in range(len(points))]
                contains=[poly.contains(point1[k]) for k in range(len(point1))]
                temp+=[points[k] for k in range(len(points)) if contains[k]]
                temp+=temp+[[int(np.floor(coord[0][k][0])),int(np.floor(coord[0][k][1]))] for k in range(coord[0].shape[0])]
                temp+=temp+[[int(np.ceil(coord[0][k][0])),int(np.floor(coord[0][k][1]))] for k in range(coord[0].shape[0])]
                temp+=temp+[[int(np.floor(coord[0][k][0])),int(np.ceil(coord[0][k][1]))] for k in range(coord[0].shape[0])]
                temp+=temp+[[int(np.ceil(coord[0][k][0])),int(np.ceil(coord[0][k][1]))] for k in range(coord[0].shape[0])]
                for p in range(len(temp)):
                    if temp[p] not in curr_mask[j]:
                        curr_mask[j].append(temp[p])
                
            except:
                pass
        
        
        
    curr_mask=[np.asarray(curr_mask[k],dtype='int') for k in range(len(curr_mask)) if len(curr_mask[k])!=0]
    curr_mask=np.concatenate(curr_mask,axis=0)
    curr_mask=np.unique(curr_mask,axis=0)
    return  curr_mask

pool = mp.Pool(mp.cpu_count())
filenames=[mypath+files[k] for k in range(len(files)) if os.path.isfile(mypath+files[k]) and files[k][-4:]=='hdf5']

results = pool.map_async(add_cell_to_mask, filenames)
results=results.get()
#results = [pool.apply(add_cell_to_mask, args=(filenames[k],)) for k in range(30)]
#results = [r.get()[1] for r in results]
pool.close()
mask=np.concatenate(results,axis=0)
"""
for k in range(len(files)):
    if files[k][-4:]=='hdf5':
        if k%25==0:
            print(str(k/len(files)*100)+'% done')
        try:
            mask=np.concatenate((mask,add_cell_to_mask(mypath+files[k])),axis=0)
        except:
            print('failure')
            print(files[k])
            
mask=np.array(mask)
"""
mask=np.unique(mask,axis=0)
mask = mask[mask[:,1].argsort()] # First sort doesn't need to be stable.
mask = mask[mask[:,0].argsort(kind='mergesort')]
np.save('mask_parallel.npy',mask)







