import pandas as pd
import scanpy as sc
import numpy as np
def convert_anndata_to_csv(adata):
    
    data=pd.DataFrame(adata.X,index=list(adata.obs_names),columns=list(adata.var_names))
    data['x']=adata.obsm['spatial'][:,0]
    data['y']=adata.obsm['spatial'][:,1]
    
    
    try:
        data['umap_1']=adata.obsm['X_umap'][:,0]
        data['umap_2']=adata.obsm['X_umap'][:,1]
    except:
        pass
    
    try:
        data['cluster']=adata.obs['cluster']
        data['cluster_cat']=adata.obs['cluster']
    except:
        pass
    
    try:
        data['sample']=adata.obs['gen']
    except:
        try:
            data['sample']=data.obs['sample']
        except:
            data['sample']=['1']*data.shape[0]
    
    try:
        cluster_colors=adata.uns['cluster_colors']
    except:
        cluster_colors=[]
    #data['y']=flip(data['y]'])
    for key in adata.obs.keys():
        if key not in ['cluster','sample','gen']:
            data[key]=adata.obs[key]
    
    return data,cluster_colors
def flip(data):
    for sample in np.unique(data['sample']):
        mean_val=(np.max(data['y'][data['sample']==sample])+np.max(data['y'][data['sample']==sample]))/2
        data['y']=-1*(data['y']-mean_val)+mean_val
        