gtex0 <- read.delim("GTEx_Analysis_2017-06-05_v8_RNASeQCv1.1.9_gene_median_tpm.gct",
    header = TRUE, row.names = 1, skip = 2)[, -1]
colnames(gtex0) <- gsub("_$", "", gsub("\\.+", "_", colnames(gtex0)))
tmp <- gsub("\\..*", "", rownames(gtex0))
gtex0 <- gtex0[which(!duplicated(tmp)), ]
rownames(gtex0) <- gsub("\\..*", "", rownames(gtex0))

gtex <- log2(gtex0 + 1)

prot_codings <- read.delim("gencode.v43.annotation.out",
    header = TRUE,
    sep = "\t")

isect_genes <- intersect(prot_codings$GENE_ID, rownames(gtex))
gtex_prot <- gtex[isect_genes, ]  # All rows are protein coding genes (~19k)


# Median TPM expression for the 54 GTEx tissues
q_tmp <- apply(gtex_prot, 2, quantile, 0.5)

# Boolean matrix. Entry is 1 if the gene (row) is expressed above the median level in that tissue (that column)
u <- t(t(gtex_prot) > q_tmp)

# tissue_ubiquity = fraction of tissues in which the gene is expressed above median level
# 0/54: 0 <= tissue_ubiquity <= 1: 54/54
tissue_ubiquity <- rowMeans(u)


# Genes expressed above median lvl in at least one tissue and not expressed in at least one tissue
non_ubiq_genes <- names(tissue_ubiquity)[which(0 < tissue_ubiquity & tissue_ubiquity < 1)]
write.table(non_ubiq_genes, "GTEx_non_ubiq_non_zero_genes.out",
    row.names = FALSE,
    col.names = FALSE,
    quote = FALSE,
    sep = "\n")

# Genes expressed above median lvl in all 54 tissues
ubiq_high <- names(tissue_ubiquity)[which(tissue_ubiquity == 1)]
write.table(ubiq_high, "GTEx_ubiq_high_genes.out",
    row.names = FALSE,
    col.names = FALSE,
    quote = FALSE,
    sep = "\n")

# Genes expressed below median lvl in all tissues
ubiq_low <- names(tissue_ubiquity)[which(tissue_ubiquity < 1e-6)]  # == zero
write.table(ubiq_low, "GTEx_ubiq_low_genes.out",
    row.names = FALSE,
    col.names = FALSE,
    quote = FALSE,
    sep = "\n")
