## load piRNA genome-wide coverage files
## get per million mapped piRNA reads & miRNA reads per library for normalization

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/coverage/uniq_mappingV3/stranded_bam/stranded_compiled_files/")

ovary_uniq_500bp <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

headers <- c("chrom", "start","end", "reads", "coverage","strain","total_reads","strand")

ovary_uniq_piRNA_bins <- lapply(ovary_uniq_500bp, function(x) {
  z <- read.table(x, header = FALSE, sep="")
  colnames(z) <- headers-0
  
  z1 <- mutate(z, rpm=reads/total_reads)
  z2 <- subset(z1, rpm>=1)
  z3 <- z2[,c(1,2,3,6,7,9)]
  return(z3)
})

names(ovary_uniq_piRNA_bins) <- ovary_uniq_500bp

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/coverage/uniq_mappingV3/stranded_bam/RPM_filtered_and_merged/")

for (i in 1:length(ovary_uniq_piRNA_bins)) {
  write.table(ovary_uniq_piRNA_bins[i], file=paste0(names(ovary_uniq_piRNA_bins)[i], 
                                "_filtered.bed"), row.names = F, col.names = F, quote = F, sep = "\t")
}

old = list.files("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/coverage/uniq_mappingV3/stranded_bam/RPM_filtered_and_merged/",
                 pattern = "\\.bed",
                 full.names = TRUE)
new <- gsub(".txt_filtered.bed", "_filtered.bed", old)
file.rename(old, new)

## merge domains within 10kb of each other and sum up the piRNA RPM and select for domains with atleast 2 RPKM or more

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/")

ovary_piRNA_domains <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

headers <- c("chrom", "start","end","strain","total_reads","RPM")

ovary_piRNA_domains_filter <- lapply(ovary_piRNA_domains, function(x) {
  z <- read.table(x, header = FALSE, sep="")
  z1 <- mutate(z,V7=V3-V2)
  z2 <- mutate(z1, V8=V6/(V7/1000))
  z3 <- subset(z2,V8>2)
  z4 <- z3[,c(1,2,3,8)]
  return(z4)
})

names(ovary_piRNA_domains_filter) <- ovary_piRNA_domains

for (i in 1:length(ovary_piRNA_domains_filter)) {
  write.table(ovary_piRNA_domains_filter[i], file=paste0(names(ovary_piRNA_domains_filter)[i],".RPKMfilter"), sep = "\t",
              row.names = F, col.names = F, quote = F)
}

old = list.files("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysis/piRNA_domains/",
                 pattern = "\\.filtered",
                 full.names = TRUE)
new <- gsub(".txt.filtered", "_filtered.bed", old )
file.rename(old, new)

## uniq_piRNA_count

sapply(names(uniq_piRNAs_library_list), 
       function (x) write.table(uniq_piRNAs_library_list[[x]], file=paste(x, "txt", sep="\t") )   )

customFun  = function(piRNA_domain_merged_uniq_readsV3) {
  write.csv(piRNA_domain_merged_uniq_readsV3,
            paste0("Uniq_reads_",unique(piRNA_domain_merged_uniq_readsV3$V5),".bed"))
  return(piRNA_domain_merged_uniq_readsV3)
}

piRNA_domain_merged_uniq_readsV3 %>% 
  group_by(V5) %>% 
  do(customFun(.))


# for restrctive, remove any with pPKM lower than 15 with piC composed of greater than 2

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/gene_count_permissive/")

uniq_piRNA_gene_filters <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(uniq_piRNA_gene_filters)) assign(uniq_piRNA_gene_filters[i], read.table(uniq_piRNA_gene_filters[i], 
                                                              header = FALSE, sep = "", stringsAsFactors = TRUE))

uniq_piRNA_gene_filter_select <- lapply(uniq_piRNA_gene_filters, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = TRUE)
  z1 <- subset(z,V6<2)
  z2 <- z1[,c(1:5)]
  return(z2)
})

names(uniq_piRNA_gene_filter_select) <- uniq_piRNA_gene_filters

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/gene_count_restrictive/")

for (i in 1:length(uniq_piRNA_gene_filter_select)) {
  write.table(uniq_piRNA_gene_filter_select[i], file=paste0(names(uniq_piRNA_gene_filter_select)[i], "pPKMV2.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

## merge within replicates

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/")

uniq_piRNA_domains <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(uniq_piRNA_domains)) assign(uniq_piRNA_domains[i], read.table(uniq_piRNA_domains[i], 
                                                header = FALSE, sep = "", stringsAsFactors = TRUE))

uniq_piRNA_domain_select <- lapply(uniq_piRNA_domains, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = TRUE)
  z1<- mutate(z,V7=(V5-V4))
  z1 <- mutate(z1, V8=V7/1000)
  z2<- mutate(z1,V9=V1/(4*V8))
  z3<- mutate(z2, pPKM=V9/V6)
  z4 <- subset(z3, pPKM>=8)
  z5 <- z4[,c(3,4,5,2,10)]
  return(z5)
})

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/restrictive/")

names(uniq_piRNA_domain_select) <- uniq_piRNA_domains

for (i in 1:length(uniq_piRNA_domain_select)) {
  write.table(uniq_piRNA_domain_select[i], file=paste0(names(uniq_piRNA_domain_select)[i], ".bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

## filter low mappability windows adjacent to piRNAs domains to merge (permissive)

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/permissive/subtracted_for_GEM/")
lowMap_piRNA_domains <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(lowMap_piRNA_domains)) assign(lowMap_piRNA_domains[i], read.table(lowMap_piRNA_domains[i], 
                                                                                 header = FALSE, sep = "", stringsAsFactors = TRUE))

lowMap_piRNA_domain_select <- lapply(lowMap_piRNA_domains, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = TRUE)
  z1<- mutate(z,V5=(V3-V2))
  z2 <- subset(z1, V4<0.3 & V5<15001)
  z3 <- z2[,c(1,2,3)]
  return(z3)
})

names(lowMap_piRNA_domain_select) <- lowMap_piRNA_domains

for (i in 1:length(lowMap_piRNA_domain_select)) {
  write.table(lowMap_piRNA_domain_select[i], file=paste0(names(lowMap_piRNA_domain_select)[i], "filtered.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

## restrcitive
setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/restrictive/subtracted_for_GEM/")
lowMap_piRNA_domains <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(lowMap_piRNA_domains)) assign(lowMap_piRNA_domains[i], read.table(lowMap_piRNA_domains[i], 
                                                    header = FALSE, sep = "", stringsAsFactors = TRUE))

lowMap_piRNA_domain_select <- lapply(lowMap_piRNA_domains, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = FALSE)
  z1<- mutate(z,V5=(V3-V2))
  z2 <- subset(z1, V4 < 0.1 & V5<15001)
  z3 <- z2[,c(1,2,3)]
  return(z3)
})

names(lowMap_piRNA_domain_select) <- lowMap_piRNA_domains

for (i in 1:length(lowMap_piRNA_domain_select)) {
  write.table(lowMap_piRNA_domain_select[i], file=paste0(names(lowMap_piRNA_domain_select)[i], "filtered.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

piRNA_domains_pPKM_filtered_restrictive <- read.delim("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/restrictive/piRNA_domains_pPKM_filtered_restrictive.txt", header=FALSE)
piRNA_domains_pPKM_filtered_restrictive <- mutate(piRNA_domains_pPKM_filtered_restrictive,V6=V3-V2)
piRNA_domains_pPKM_filtered_restrictive_SUM <- piRNA_domains_pPKM_filtered_restrictive %>% group_by(V4) %>% summarise(V7=sum(V6))

ggplot(piRNA_domains_pPKM_filtered_restrictive_SUM,aes(x=V4,y=V7/1000000)) + 
  geom_bar(stat = "identity", fill="orchid2") +  theme_bw() +
  theme(panel.grid.minor = element_blank(),
        strip.background = element_blank(),
        panel.border = element_rect(colour = "black"), 
        axis.text.x =element_text(size = 13, color = "black", angle = 45, hjust = 0.9),
        panel.background = element_rect(), legend.position = "none", 
        axis.title = element_text(size=13, color = "black", face = "bold")) + 
  scale_y_continuous(limits = c(0,5.5), breaks = c(0,1,2,3,4,5))

ggplot(restrictive_piC_domain_lowMap_merged_count,aes(x=V4,y=n)) + 
  geom_bar(stat = "identity", fill="skyblue4") +  theme_bw() +
  theme(panel.grid.minor = element_blank(),
        strip.background = element_blank(),
        panel.border = element_rect(colour = "black"), 
        axis.text.y = element_text(size = 15, color = "black"),
        axis.text.x =element_text(size = 13.5, color = "black", angle = 45, hjust = 0.9, vjust = 0.8),
        panel.background = element_rect(), legend.position = "none", 
        axis.title = element_text(size=13, color = "black", face = "bold")) + 
  scale_y_continuous(limits = c(0,375), breaks = c(100,150,200,250,300,350)) + 
  ylab("piRNA clusters count (restrictive)\n")

## additional curation for genic clusters (subtract or curate bounadaries of large piC with >10 annotated genes)
## restrictive

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/restrictive/genes_merge/merged/")

genes_piRNA_domains <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(genes_piRNA_domains)) assign(genes_piRNA_domains[i], read.table(genes_piRNA_domains[i], 
                                                                                     header = FALSE, sep = "", stringsAsFactors = TRUE))

genes_piRNA_domain_select <- lapply(genes_piRNA_domains, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = FALSE)
  z1<- mutate(z,V5=(V3-V2))
  ## first convert length from bps to kbps 
  z2 <- mutate(z1, V6=V5/1000)
  ## and then calculate genes per Kb per cluster
  z3 <- mutate(z2, V7=V4/V6)
  z4 <- subset(z3, V6>10 & V7>0.3)
  z5 <- z4[,c(1,2,3,6,7)]
  return(z5)
})

names(genes_piRNA_domain_select) <- genes_piRNA_domains

for (i in 1:length(genes_piRNA_domain_select)) {
  write.table(genes_piRNA_domain_select[i], file=paste0(names(genes_piRNA_domain_select)[i], "TBC.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

## additional curation for highly genic piC (permissive)

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/permissive/highMap_unmerge/")

genes_piRNA_domains <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(genes_piRNA_domains)) assign(genes_piRNA_domains[i], read.table(genes_piRNA_domains[i], 
                                                                                   header = FALSE, sep = "", stringsAsFactors = TRUE))

genes_piRNA_domain_select <- lapply(genes_piRNA_domains, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = FALSE)
  z1<- mutate(z,V5=(V3-V2))
  ## first convert length from bps to kbps 
  z2 <- mutate(z1, V6=V5/1000)
  ## and then calculate genes per Kb per cluster
  z3 <- mutate(z2, V7=V4/V6)
  z4 <- subset(z3, V6>10 & V7>0.2)
  z5 <- z4[,c(1,2,3,6,7)]
  return(z5)
})

names(genes_piRNA_domain_select) <- genes_piRNA_domains

for (i in 1:length(genes_piRNA_domain_select)) {
  write.table(genes_piRNA_domain_select[i], file=paste0(names(genes_piRNA_domain_select)[i], "TBC.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

# additonal filtering by RPM to remove lowly expressed genic piRNAs

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_RPM_analysisV2/piRNA_cluster_remapping/split_bam_files/edited_dedupe_files/permissive/highMap_unmerge/")

genes_piRNA_RPM <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)
for (i in 1:length(genes_piRNA_RPMs)) assign(genes_piRNA_RPMs[i], read.table(genes_piRNA_RPMs[i], 
                                                                                   header = FALSE, sep = "", stringsAsFactors = TRUE))

genes_piRNA_RPM_select <- lapply(genes_piRNA_RPM, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = FALSE)
  z1<- mutate(z,V6=(V3-V2))
  ## first convert length from bps to kbps 
  z2 <- mutate(z1, V7=V6/1000)
  ## and then calculate genes per Kb per cluster
  z3 <- mutate(z2, V8=V5/V7)
  z4 <- z3[,c(1,2,3,4,8)]
  return(z4)
})

names(genes_piRNA_RPM_select) <- genes_piRNA_RPM

for (i in 1:length(genes_piRNA_RPM_select)) {
  write.table(genes_piRNA_RPM_select[i], file=paste0(names(genes_piRNA_RPM_select)[i], "RPM.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

###

circos.par("track.height"=0.14,"gap.after"=c("2L"=1,"2R"=1,"3L"=1,
                                             "3R"=1,"X"=1,"4"=1),
           cell.padding = c(0.02, 0, 0.02, 0), "clock.wise"=TRUE)

circos.genomicInitialize(ISO1_genome_25nt_mappability_10kb,
                         axis.labels.cex = 0.6*par("cex"), 
                         labels.cex = 1.2*par("cex"))

circos.genomicTrackPlotRegion(ISO1_genome_25nt_mappability_10kb, numeric.column = 4, 
                              ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.4,
                                                    area = TRUE, col = "honeydew1")
                              })

circos.genomicTrackPlotRegion(ISO1_ovary_rep1_piRNA_2mm_multi_genome_10kb, numeric.column = 6, 
                              ylim = c(0,10),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.2,
                                                    area = TRUE, col = "lightyellow2")
                              })

circos.genomicTrackPlotRegion(ISO1_ovary_rep2_piRNA_2mm_uniq_genome_2kb, numeric.column = 6, 
                              ylim = c(0,12),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.1,
                                                    area = TRUE, col = "seashell")
                              })

circos.par("track.height"=0.14,"gap.after"=c("2L"=1,"2R"=1,"3L"=1,
                                             "3R"=1,"X"=1,"4"=1),
           cell.padding = c(0.02, 0, 0.02, 0), "clock.wise"=TRUE)

circos.genomicInitialize(ISO1_ovary_piRNA_clusters,
                         axis.labels.cex = 0.6*par("cex"), 
                         labels.cex = 1.2*par("cex"))

circos.genomicTrackPlotRegion(ISO1_ovary_piRNA_clusters, numeric.column = 4, 
                              ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.2,
                                                    area = TRUE, col = "firebrick")
                              })

circos.genomicTrackPlotRegion(ISO1_ovary_piRNA_clusters_replicated_10kb, numeric.column = 4, 
                              ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.2,
                                                    area = TRUE, col = "orange")
                              })

circos.genomicTrackPlotRegion(ISO1_ovary_piRNA_clusters_replicated_10kb, numeric.column = 4, 
                              ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.2,
                                                    area = TRUE, col = "orange")
                              })

## piRNA domain filtering by 1U and unique piRNA count
## 
setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domains/domain_filtering_by_fastqc/base_1U/")

domain_filter <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)
for (i in 1:length(domain_filter)) assign(domain_filter[i], read.table(domain_filter[i], 
                            header = FALSE, sep = "", stringsAsFactors = TRUE))

headers <- c("base1_U","strain","rep","chrom","start","end")

domain_filtered <- lapply(domain_filter, function(x) {
  z <- read.table(x, header = FALSE, sep="", stringsAsFactors = TRUE)
  colnames(z)<- headers
  z1 <- subset(z, base1_U>50)
  return(z1)
})

names(domain_filtered)<- domain_filter

for (i in 1:length(domain_filtered)) {
  write.table(domain_filtered[i], file=paste0(names(domain_filtered)[i], "1U_50p.bed"), 
              row.names = F, col.names = F, quote = F, sep = "\t")
}

## select piC for master-list by filtering the multiIntersectBed results

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/master_coords/multiIntrersectBed_result/")

piC_master <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

for (i in 1:length(piC_master)) assign(piC_master[i], read.table(piC_master[i], 
                                      header = TRUE, sep = "", stringsAsFactors = FALSE))

library(dplyr)

piC_master_dfs <- lapply(piC_master, function(x) {
  z <- read.table(x, header = T, sep="", stringsAsFactors = T)
  z1 <- z[,c(1:4)]
  z2 <- subset(z1, num>1)
  z3 <- z2[,c(1,2,3)]
  return(z3)
})

names(piC_master_dfs) <- piC_master

for (i in 1:length(piC_master_dfs)) {
  write.table(piC_master_dfs[i], file=paste0(names(piC_master_dfs)[i], ".bed"), row.names = F, col.names = F, sep = "\t", quote = F)
}

## analyze shared piC between two replicates 

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/master_coords/multiIntersect_filter/common_piC_remerged/")

piC_master_filtered_reps <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

for (i in 1:length(piC_master_filtered_reps)) assign(piC_master_filtered_reps[i], read.table(piC_master_filtered_reps[i], 
                                                                 header = F, sep = "", stringsAsFactors = FALSE))

piC_master_filtered_reps_dfs <- lapply(piC_master_filtered_reps, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = T)
  z1 <- mutate(z,V4=V3-V2)
  z2 <- subset(z1, V4>1999)
  z3 <- z2[,c(1,2,3)]
  return(z3)
})

names(piC_master_filtered_reps_dfs) <- piC_summary(b3_omaster_filtered_reps)

for (i in 1:length(piC_master_filtered_reps_dfs)) {
  write.table(piC_master_filtered_reps_dfs[i], file=paste0(names(piC_master_filtered_reps_dfs)[i], "1kb.bed"), 
              row.names = F, col.names = F, sep = "\t", quote = F)
}

## filter proTRACv3 clusters by expression, >25 rpm only 

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/coverage/uniq_mappingV3/proTRAC_prediction/proTRACv3/bed_files/")

piC_master_merged_reps <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

for (i in 1:length(piC_master_merged_reps)) assign(piC_master_merged_reps[i], read.table(piC_master_merged_reps[i], 
                                              header = F, sep = "", stringsAsFactors = FALSE))

piC_master_merged_reps_dfs <- lapply(piC_master_merged_reps, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = T)
  z1 <- mutate(z,V6=V4/V5)
  z2 <- subset(z1, V6>20)
  z3 <- z2[,c(1,2,3,6)]
  return(z3)
})

names(piC_master_merged_reps_dfs) <- piC_master_merged_reps

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/coverage/uniq_mappingV3/proTRAC_prediction/proTRACv3/bed_files/filtered_25rpm/")

for (i in 1:length(piC_master_merged_reps_dfs)) {
  write.table(piC_master_merged_reps_dfs[i], file=paste0(names(piC_master_merged_reps_dfs)[i], "RPM.bed"), 
              row.names = F, col.names = F, sep = "\t", quote = F)
}

## master coords piRNA cluster 

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysipiC2/remap_piC_pPKMv2/master_coords/multiIntersectBed_resultV1/")

piC_filter <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

for (i in 1:length(piC_filter)) assign(piC_filter[i], read.table(piC_filter[i], 
                                          header = T, sep = "", stringsAsFactors = FALSE))

piC_filter_dfs <- lapply(piC_filter, function(x) {
  z <- read.table(x, header = T, sep="", stringsAsFactors = T)
  z1 <- subset(z, num>1)
  z2 <- mutate(z1, length=end-start)
  z3 <- subset(z2,length>499)
  z4 <- z3[,c(1,2,3)]
  return(z4)
})

names(piC_filter_dfs) <- piC_filter

for (i in 1:length(piC_filter_dfs)) {
  write.table(piC_filter_dfs[i], file=paste0(names(piC_filter_dfs)[i], "common.bed"), row.names = F, col.names = F, sep = "\t", 
              quote = F)
}

## multiInter uniq piC piRNA coverage

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/master_coords/uniq_piC_piRNA_coverage/normalized_coverage/")

piC_filter <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

for (i in 1:length(piC_filter)) assign(piC_filter[i], read.table(piC_filter[i], 
                                                                 header = F, sep = "", stringsAsFactors = FALSE))

piC_filter_dfs <- lapply(piC_filter, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = T)
  z1 <- mutate(z, V9=V4/V8)
  z2 <- subset(z1,V9>10)
  z3 <- z2[,c(1,2,3)]
  return(z3)
})

names(piC_filter_dfs) <- piC_filter

for (i in 1:length(piC_filter_dfs)) {
  write.table(piC_filter_dfs[i], file=paste0(names(piC_filter_dfs)[i], "10RPM.bed"), row.names = F, col.names = F, sep = "\t", 
              quote = F)
}


##
setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/gem_mappability/mean_mappability/")

meanMapp_filter <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

for (i in 1:length(meanMapp_filter)) assign(meanMapp_filter[i], read.table(meanMapp_filter[i], 
                                                                        header = F, sep = "", stringsAsFactors = FALSE))

meanMapp_filter_dfs <- lapply(meanMapp_filter, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = T)
  z1 <- subset(z,V4>=0.25)
  return(z1)
})

names(meanMapp_filter_dfs) <- meanMapp_filter

for (i in 1:length(meanMapp_filter_dfs)) {
  write.table(meanMapp_filter_dfs[i], file=paste0(names(meanMapp_filter_dfs)[i], "V1.bed"), row.names = F, col.names = F, sep = "\t", 
              quote = F)
}

##

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/master_coords/final_remerged_highMap_removed_proTRAC/")

piClength_filter <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

for (i in 1:length(piClength_filter)) assign(piClength_filter[i], read.table(piClength_filter[i], 
                                                                           header = F, sep = "", stringsAsFactors = FALSE))

piClength_filter_dfs <- lapply(piClength_filter, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = T)
  z1 <- mutate(z, V4=V3-V2)
  z1 <- subset(z,V4>400)
  return(z1)
})

names(piClength_filter_dfs) <- piClength_filter

for (i in 1:length(piClength_filter_dfs)) {
  write.table(piClength_filter_dfs[i], file=paste0(names(piClength_filter_dfs)[i], "V1.bed"), row.names = F, col.names = F, sep = "\t", 
              quote = F)
}

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/remap_021122/masterList_remap/replicate_combined/")

piCremap_edit <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

for (i in 1:length(piCremap_edit)) assign(piCremap_edit[i], read.table(piCremap_edit[i], 
                                                                             header = F, sep = "", stringsAsFactors = FALSE))

piCremap_edit_dfs <- lapply(piCremap_edit, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = F)
  z1 <- mutate(z, V6=V4-V3)
  z2 <- z1[,c(2,3,4,5,6,1)]
  z3 <- z2[z2$V1==z2$V2,]
  return(z3)
})

names(piCremap_edit_dfs) <- piCremap_edit

for (i in 1:length(piCremap_edit_dfs)) {
  write.table(piCremap_edit_dfs[i], file=paste0(names(piCremap_edit_dfs)[i], "V2.bed"), row.names = F, col.names = F, sep = "\t", 
              quote = F)
}

## circos plot for curated remapped strain clusters along with complete 8-strain-list

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/remap_021122/SSpiC_bed_files/replicate_combined/10%_overlap_intersect/")

piCremap_circos <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

for (i in 1:length(piCremap_circos)) assign(piCremap_circos[i], read.table(piCremap_circos[i], 
                                                                       header = F, sep = "", stringsAsFactors = FALSE))

A1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(A1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
A2_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(A2_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
A4_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(A4_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
A7_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(A7_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
ISO1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(ISO1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
OreR_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(OreR_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
B3_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(B3_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)
B6_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt <- subset(B6_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, V4>0)


ISO1_genome_25nt_mappability_chrom10kb.txt <- ISO1_genome_25nt_mappability_chrom10kb.txt %>% filter(V1 %in% c("2L","2R","3L",
                         "3R","X","4"))
library(circlize)

circos.par("track.height"=0.07, "clock.wise"=TRUE, 
           "gap.after"=c("2L"=2,"2R"=2,"3L"=2,
                         "3R"=2,"X"=2,"4"=2),
           cell.padding = c(0, 0, 0, 0))

circos.genomicInitialize(ISO1_genome_25nt_mappability_chrom10kb,
                         axis.labels.cex = 0.85*par("cex"), 
                         labels.cex = 0.05*par("cex"), major.by = 8000000)

circos.genomicTrackPlotRegion(ISO1_genome_25nt_mappability_chrom10kb, numeric.column = 4, 
                              ylim = c(0,0.95),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.2,
                                                    area = TRUE, col = "lemonchiffon1")
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(ISO1_ovary_allMethods_multiIntersect_common_remergedV3_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "salmon2", type = 'h', lwd=0.3)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "slateblue2", lwd=0.3, type = 'h')
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A2_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "olivedrab4", type = 'h', lwd=0.3)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A4_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "tomato", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A7_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "orange3", lwd=0.25, type = 'h')
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(B3_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                area = TRUE, col = "mediumorchid2", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(B6_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                            area = TRUE, col = "steelblue3", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(OreR_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_ISO1.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                        area = TRUE, col = "darkolivegreen4", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

##

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/remap_021122/SSpiC_bed_files/replicate_combined/TAp_intersect/")

piC_TAp_circos <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

for (i in 1:length(piC_TAp_circos)) assign(piC_TAp_circos[i], read.table(piC_TAp_circos[i], 
                                                header = F, sep = "", stringsAsFactors = FALSE))
library(circlize)

circos.par("track.height"=0.07, "clock.wise"=TRUE, 
           "gap.after"=c("2L"=2,"2R"=2,"3L"=2,
                         "3R"=2,"X"=2,"4"=2),
           cell.padding = c(0, 0, 0, 0))

circos.genomicInitialize(ISO1_genome_25nt_mappability_chrom10kb.txt,
                         axis.labels.cex = 0.85*par("cex"), 
                         labels.cex = 0.05*par("cex"), major.by = 8000000)

circos.genomicTrackPlotRegion(ISO1_genome_25nt_mappability_chrom10kb.txt, numeric.column = 4, 
                              ylim = c(0,0.9),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.3,
                                                    area = TRUE, col = "lemonchiffon1")
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(ISO1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "salmon2", type = 'h', lwd=0.3)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A1_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "slateblue2", lwd=0.25, type = 'h')
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A2_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "olivedrab3", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A4_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "tomato", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A7_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "orange2", lwd=0.2, type = 'h')
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(B3_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "mediumpurple1", type = 'h', lwd=0.2)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(B6_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "steelblue3", type = 'h', lwd=0.2)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(OreR_ovary_allMethods_common_remergedV3_remap_SSpiC_remerged_TAp.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "darkolivegreen4", type = 'h', lwd=0.2)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

## proTRACv3 remap intersection result (Supp Fig S4)

DSPR_proTRACv3_curated_intersection_matrix<-acast(DSPR_proTRACv3_curated_intersection, V2~V3, value.var="V1")

DSPR_proTRACv3_curated_intersection_matrix_prop <- 
  t(t(DSPR_proTRACv3_curated_intersection_matrix)/diag(DSPR_proTRACv3_curated_intersection_matrix))

pheatmap(DSPR_proTRACv3_curated_intersection_matrix_prop, cluster_rows = F, cluster_cols = F, fontsize = 11, angle_col = 45, 
         cellheight = 20, cellwidth = 25, color = colorRampPalette(rev(brewer.pal(n = 9, name ="RdYlBu")))(200))

pheatmap(DSPR_proTRACv3_curated_intersection_matrix_prop, cluster_rows = F, cluster_cols = F, angle_col = 45, cellheight = 14, 
         cellwidth = 20, color = colorRampPalette(rev(brewer.pal(n = 9, name ="RdYlBu")))(200), fontsize_row = 10, fontsize_col = 11, 
         legend_breaks = c(0,0.2,0.4,0.6,0.8,1), legend_labels = c("0%","20%","40%","60%","80%","100%"), 
         border_color = "grey40", fontsize = 10)

## Main Fig 1A


DSPR_restrictive_curated_intersection_matrix<-acast(DSPR_restrictive_curated_intersect, V2~V3, value.var="V1")

DSPR_restrictive_curated_intersection_matrix_prop <-t(t(DSPR_restrictive_curated_intersection_matrix)/diag(DSPR_restrictive_curated_intersection_matrix))


pheatmap(DSPR_restrictive_curated_intersection_matrix_prop, cluster_rows = F, cluster_cols = F, angle_col = 45, cellheight = 14, 
         cellwidth = 20, color = colorRampPalette(rev(brewer.pal(n = 9, name ="RdYlBu")))(200), fontsize_row = 10, fontsize_col = 11, 
         legend_breaks = c(0,0.2,0.4,0.6,0.8,1), legend_labels = c("0%","20%","40%","60%","80%","100%"), 
         border_color = "grey40", fontsize = 10)

## summarise the unmapped allMethods remapped piC

setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/remap_021122/masterList_remap/unmapped_piC/curated_unmapped_ApiC/")

piCremap_unmapped_SUM <- list.files(path = ".", pattern = "\\.bed$", full.names = FALSE)

for (i in 1:length(piCremap_unmapped_SUM)) assign(piCremap_unmapped_SUM[i], read.table(piCremap_unmapped_SUM[i], 
                                                                       header = F, sep = "", stringsAsFactors = FALSE))

piCremap_unmapped_SUM_dfs <- lapply(piCremap_unmapped_SUM, function(x) {
  z <- read.table(x, header = F, sep="", stringsAsFactors = F)
  z1 <- mutate(z, V4=V3-V2)
  z2 <- mutate(z1, V5=sum(V4))
  z3 <- distinct(z2, V5,V4)
  return(z3)
})

names(piCremap_unmapped_SUM_dfs) <- piCremap_unmapped_SUM

for (i in 1:length(piCremap_unmapped_SUM_dfs)) {
  write.table(piCremap_unmapped_SUM_dfs[i], file=paste0(names(piCremap_unmapped_SUM_dfs)[i], "SUM.txt"), row.names = F, col.names = F, sep = "\t", 
              quote = F)
}

ggplot(DSPR_allMethods_common_ApiC_remap_NULL_length_compiled, aes(x=V3,y=log10(V1), fill=V4)) + 
  geom_point(size=1, alpha=0.8) + geom_boxplot(position = "dodge", alpha=0.5) + xlab("samples") + ylab("log10(Unmapped ApiC-length bps)") + theme_bw() +  
  theme(panel.grid.minor = element_blank(), legend.title = element_text(size = 12),
        strip.background = element_blank(), panel.border = element_rect(colour = "black"),
        axis.text =element_text(size = 13, color = "black"), legend.position = "none", panel.background = element_rect(), axis.text.x = element_text(angle = 45, size=13, hjust = 0.99), axis.text.y = element_text(hjust = 1),
        axis.title = element_text(size=13, color = "black",face = "bold")) +labs(fill="strains") + 
  scale_fill_brewer(palette = "Dark2", type = div) + scale_y_continuous(breaks = c(3,4,5))


setwd("/local/workdir/sps257/dspr_piRNA/mapping/genome_mapping/piRNA_domain_analysisV2/remap_piC_pPKMv2/remap_021122/masterList_circos/")

master_piC_circos <- list.files(path = ".", pattern = "\\.txt$", full.names = FALSE)

for (i in 1:length(master_piC_circos)) assign(master_piC_circos[i], read.table(master_piC_circos[i], 
                                                  header = F, sep = "", stringsAsFactors = FALSE))
library(circlize)


circos.par("track.height"=0.07, "clock.wise"=TRUE, 
           "gap.after"=c("2L"=2,"2R"=2,"3L"=2,
                         "3R"=2,"X"=2,"4"=2),
           cell.padding = c(0, 0, 0, 0))

circos.genomicInitialize(ISO1_genome_25nt_mappability_chrom10kb,
                         axis.labels.cex = 1*par("cex"), 
                         labels.cex = 2*par("cex"), major.by = 10000000)

circos.genomicTrackPlotRegion(ISO1_genome_25nt_mappability_chrom10kb, numeric.column = 4, 
                              ylim = c(0,0.9),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,  lwd=0.2,
                                                    area = TRUE, col = "azure2")
                              }, bg.border=0)

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(ISO1_ovary_allMethods_multiIntersect_common_remergedV3_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "sienna2", type = 'h', lwd=0.3)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A1_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "slateblue2", lwd=0.25, type = 'h')
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A2_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "olivedrab3", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A4_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "tomato", type = 'h', lwd=0.25)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(A7_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = TRUE, col = "orange3", lwd=0.25, type = 'h')
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(B3_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "mediumpurple1", type = 'h', lwd=0.2)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(B6_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "steelblue3", type = 'h', lwd=0.2)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)

circos.genomicTrackPlotRegion(OreR_ovary_allMethods_multiIntersect_common_remergedV3_remapV2_merge_10kb.txt, 
                              numeric.column = 4, ylim = c(0,1),
                              panel.fun = function(region, value, ...) {
                                circos.genomicLines(region, value, ...,
                                                    area = FALSE, col = "darkolivegreen4", type = 'h', lwd=0.2)
                              }, bg.border=0 )

set_track_gap(gap = 0.0)
