% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_one_to_ones.R
\name{load_one_to_ones}
\alias{load_one_to_ones}
\title{Load one-to-one orthogroups for a set of species}
\usage{
load_one_to_ones(file, species = NULL)
}
\arguments{
\item{file}{Path to the \emph{OrthoFinder} table.}

\item{species}{A character vector of species annotation names matching
exactly the names of the columns in the \emph{OrthoFinder} table.}
}
\value{
Returns a \code{\link{DataFrame}} with one column per species, containing
protein identifiers, and the columns \code{HOG}, \code{OG} and \code{Gene.Tree.Parent.Clade}.
}
\description{
Takes a \emph{phylogenetic hierarchical orthogroup} table from the output of
\emph{OrthoFinder}, optionally subsets it for some species, and returns the
table containing one-to-one orthogroups.
}
\details{
Orthogroups that are not one-to-one have either a missing entry for one
species, represented as an empty string, or multiple entries, separated
with comma characters.  Species that are not part of the clade covered by
the table have \code{NA} in every row.
}
\examples{
# Example for loading all orthogroups:
OikScrambling:::load_one_to_ones(system.file("extdata/OrthoFinder/N19.tsv", package = "BreakpointsData"))

# Example for loading a pair
OikScrambling:::load_one_to_ones( system.file("extdata/OrthoFinder/N19.tsv", package = "BreakpointsData")
                                  , c("Bar2_p4.Flye.prot.longest.fa_1", "OSKA2016v1.9.prot.longest.fa_1"))

}
