# Supplemental Code

Supplement to the manuscript _Extreme genome scrambling in marine planktonic
Oikopleura dioica cryptic species_.

The files here were extracted from the following GitHub repository
(revision 8e2813d43950d3a55c836a29518970784b50b038).

   https://github.com/oist/LuscombeU_OikScrambling/

The "docs" directory, which is rebuildable and weights half a gigabyte was
removed, but it is still available from GitHub (see above) and Zenodo
(10.5281/zenodo.6601988). 

This is a R package containing a collection of vignettes to perform the
analysis of pairwise genome alignments between _Oikopleura_ genomes.

The following vignettes are suplemental material to our manuscript and contain
source code containing figure panels.

 - Figure 1B and S1 DNA line plots (OxfordPlots.Rmd)
 - Figure 1C chromosome parallel plots (ParallelPlots.Rmd)
 - Figure 1D scrambling index (DistanceMeasures.Rmd)
 - Figure 2A and S1 orthogroup dot plots and synteny block histograms (OrthogroupSyntenies.Rmd)
 - Figure 3C breakpoint feature density plots (GenomicFeatures.Rmd)
 - Figure 4B and 4C operon barplots (OperonDetection.Rmd)
 - Figure 5 genome-wide feature patterns (ChromosomePlots.Rmd)
 - Figure 7A–D DNA line plots (SquareWindowPlots.Rmd)
 - Figure 7E breakpoint number barplots (ScalingBreakpoints.Rmd)

The other vignettes are included as an open notebooke for the curious reader.

See the “Get Started“ vignette for details on how to run the computations.

The core functions used here are maintained in our _GenomicBreaks_ R package,
which is fully documented at: <https://oist.github.io/GenomicBreaks>.
