import XYMsimulation
import numpy as np
import sys
import json

args = sys.argv

# number of simulation runs
NSIM = 1000
# effective population size
N = 2000

### this program will take 7 parameters
### to change other parameters, we have to directly change this script
ALPHA = float(args[1]) #RAA
BETA = float(args[2]) #RXA
GAMMA = float(args[3]) #RMA
DELTA = float(args[4]) #RXY
EPSILON = float(args[5]) #male-to-female sex ratio when Y is longer
NMIG = float(args[6]) # NM unit
RECOM = float(args[7]) # recombination rate between SD and XHI

parameters = {
    'N':N,
    'ALPHA':ALPHA,## autosomal HI, RAA
    'BETA':BETA,## X chromosomal HI, RXA
    'GAMMA':GAMMA,## mitochondrial effect, RMA
    'DELTA':DELTA, ## ferterity reduction of sex-bias, RXY
    'EPSILON':EPSILON, ## male-to-female sex ratio when Y is longer, alpha
    'MU_Y':0,
    'MU_X':0,
    'RECOM':RECOM,
    'INIT_L_RATIO':1e-2,
    'GEN':int(N/10), # upto 0.1N generation
    'NMIG': NMIG, ## migration rate, Nm
    'MALE': 0.5,
    'VERBOSE': 10,
    'DIRECTION': 0 ## direction of gene flow, 0 means long haplotype introgress, 1 means short haplotype introgress
}

a = str(parameters['ALPHA'])
b = str(parameters['BETA'])
c = str(parameters['GAMMA'])
d = str(parameters['DELTA'])
e = str(parameters['EPSILON'])
r = str(parameters['RECOM'])
m = str(parameters['NMIG'])

param = "_RAA"+a+"_RXA"+b+"_RMA"+c+"_RXY"+d+"_a"+e+"_m"+m+"._r"+r
# e = e.replace('.', '')
print(param)

list_Y = []
list_X = []
list_M = []
list_A = []

for i in range(NSIM):
    print(i)
    results = XYMsimulation.XYM_simulation_geneflow(parameters)

    mean_Y = results['mean_Y_hap']
    mean_X = results['mean_X_hap']
    mean_M = results['mean_M']
    mean_A = results['mean_G']
    list_Y.append(mean_Y)
    list_X.append(mean_X)
    list_M.append(mean_M)
    list_M.append(mean_A)

data = {'Y': list_Y, 'X': list_X, "M": list_M, "A": list_A}

## output file contains list of tranjectory of four values
## mean_Y, mean_X, mean_M, mean_A. 'mean' is frequency of allele type 1.
with open("XYMsimulation"+param+".json", 'w') as outfile:
    json.dump(data, outfile)