#!/usr/bin/env python
import os
import sys
import inspect
import re
import collections
import argparse

def load_popfreqs(pffile):
	pfh=collections.defaultdict(lambda:{})
	for line in open(pffile):
		"""
		0	1			2			3	4			5	6	7	8
		1	contig_422	15624441	+	P-element	TIR	F	-	0.138
		1	contig_422	15726529	+	P-element	TIR	F	-	0.306
		"""
		a=line.rstrip("\n").split("\t")
		chrm=a[1]
		pos=int(a[2])
		popfreq=float(a[8])
		pfh[chrm][pos]=popfreq
	return pfh



parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Authors
-------
    Robert Kofler
""")
parser.add_argument("--flep", type=str, required=True, dest="flep", default=None, help="fl-ep")
parser.add_argument("--popte2", type=str, required=True, dest="popfreq", default=None, help="popfreq")
# parser.add_argument("--minlen", type=int, required=False, dest="minlen", default=100, help="minlen")
args,unknown = parser.parse_known_args()

popfreqhash=load_popfreqs(args.popfreq)
# how to deal with duplicates; remove them from popfreqhash!

for line in open(args.flep):
	# contig_513	8241519	EP	F	fwd
	# contig_513	11229121	EP	FR	fwd
	a=line.rstrip("\n").split("\t")
	chrm,pos=a[0],int(a[1])
	type=a[2]

	for i in range(pos-20,pos+21):
		if i in popfreqhash[chrm]:
			pf=popfreqhash[chrm][i]
			del(popfreqhash[chrm][i])
			print("{0}\t{1}\t{2}\t{3}".format(chrm,pos,type,pf))


	