#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import collections




def loadbed(file):
    # 2L	336597	337204
    # 2L	478221	478912
    # 2L	647496	648396
    toret=collections.defaultdict(lambda: [])
    for l in open(file):
        a=l.rstrip("\n").split("\t")
        chrm,start,end=a[0],int(a[1]),int(a[2])
        toret[chrm].append((start,end))
    return(toret)


            
    

parser = argparse.ArgumentParser(description="""           
Description
-----------
    Check if a P-element insertion is in a piRNA cluster""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")


parser.add_argument("--bed", type=str, required=True, dest="bed", default=None, help="bed")
parser.add_argument("--tes", type=str, required=True, dest="tes", default=None, help="te insetions")
parser.add_argument("--sid", type=str, required=True, dest="sid", default=None, help="sample ID")
args = parser.parse_args()

bed=loadbed(args.bed)
sid=args.sid
if "," in sid:
    sid=sid.split(",")




for l in open(args.tes):
    """
    0       1   2   3   4   5
    cold	1	0	4	1	-0.1
    cold	1	0	4	1400000	-0.1

    """
    l=l.rstrip("\n")
    a=l.split("\t")
    chrm,pos=a[0],a[1]
    if " " in pos:
        continue
    pos=int(pos)
    isbed=0
    bedlist=bed[chrm]
    for start,end in bedlist:
        if pos>=start and pos<=end:
            isbed=1
    topr=[]
    topr.extend(sid)
    topr.append(l)
    topr.append(str(isbed))
    print("\t".join(topr))
        
    