#!/usr/bin/env python
import os
import sys
import inspect
import re
import argparse

def split_psites(tosplit):
	tmp=[tosplit]
	if " " in tosplit:
		tmp=tosplit.split(" ")
	toret=[]
	for t in tmp:
		t=t.lstrip("+-")
		t2=t.split("..")
		toret.append(int(t2[0]))
		toret.append(int(t2[1]))
	return toret


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Authors
-------
    Robert Kofler
""")
parser.add_argument("--pele", type=str, required=True, dest="pele", default=None, help="pele insertions from P-element-insertion-finder.py")
# parser.add_argument("--minlen", type=int, required=False, dest="minlen", default=100, help="minlen")
args,unknown = parser.parse_known_args()

for line in open(args.pele):
	# contig_513	23460977	-2375..2907 -0..828	FR	fwd
    # contig_513	8241514	+0..828 +2375..2907	FR	rev
	a=line.rstrip("\n").split("\t")
	if " " in a[0] or " " in a[1]:
		continue
	chrm,pos=a[0],int(a[1])
	psites=split_psites(a[2])

	# only full length insertions are considered
	if 0 not in psites:
		continue
	if 2907 not in psites:
		continue

	# start and end is present and only two sites -> Full-length insertion
	if len(psites)==2:
		print("{0}\t{1}\tFL\t{2}\t{3}".format(chrm,pos,a[3],a[4]))

	# check EP-element: EP-element 827-2375nt.
	epstart=False
	epend=False
	for i in range(825,832):
		if i in psites:
			epstart=True
	for i in range(2372,2379):
		if i in psites:
			epend=True
	if epstart and epend:
		print("{0}\t{1}\tEP\t{2}\t{3}".format(chrm,pos,a[3],a[4]))
