#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import collections



def load_tileing(tile,tilesize):
	toret={}
	for line in open(tile):
		a=line.rstrip("\n").split("\t")
		"""
		0			1	2		3		4		5	6	7				8					9				10			
		contig_508	0	4999	5000	113	29/84	17	5.78197857567	5.92423874403	-0.486725663717	1.02460406356
		contig_508	5000	9999	5000	74	4/70	3	3.78642844778	1.04545389601	-0.891891891892	0.276105546539
		contig_508	10000	14999	5000	66	14/52	4	3.37708483181	1.39393852801	-0.575757575758	0.412763847351
		"""
		chrm,start,normoc,asebias,mattrans=a[0],int(a[1]),float(a[7]),float(a[9]),float(a[10])

		poskey=int(start/tilesize)
		assert(start%tilesize ==0)
		key="{0}:{1}".format(chrm,poskey)
		#print(start,chrm,poskey,key)
		toret[key]=[normoc,asebias,mattrans]
	return toret

def load_cluins(cli,tilesize):
	toret=[]
	for line in open(cli):
		a=line.rstrip("\n").split("\t")
		"""
		0		1	2	3				4
		dere	R2	G51	contig_422	2422868	2	1169	R	fwd	1
		dere	R2	G51	contig_422	7599762	1	528	R	rev	1
		dere	R2	G51	contig_422	7599799	1	145	F	rev	1
		"""
		chrm,pos= a[3],int(a[4])
		poskey=int(pos/tilesize)
		key="{0}:{1}".format(chrm,poskey)
		toret.append([chrm,pos,key,a])
	return toret



	





            
    

parser = argparse.ArgumentParser(description="""           
Description
-----------
    Check if a P-element insertion is in a piRNA cluster""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")


parser.add_argument("--cli", type=str, required=True, dest="cli", default=None, help="the cluster insertions (from group....py)")
parser.add_argument("--tile", type=str, required=True, dest="tile", default=None, help="the tileing of piRNAs")
parser.add_argument("--ts", type=int, required=True, dest="ts", default=None, help="the tileing window size, eg 5000bp")
args = parser.parse_args()

tileh=load_tileing(args.tile,args.ts)
clih=load_cluins(args.cli,args.ts)
#print(tileh)
#print(clih)
#print(len(tileh.items()))
#print(len(clih))

for chrm,pos,key,a in clih:
	cpt=["na","na","na"]
	if key in tileh:
		cpt=tileh[key]
	a.extend([str(i) for i in cpt])
	print("\t".join(a))