#!/bin/zsh

# read parameters
if [ $# -lt 2 ]
  # "$#" is number of parameters- here we test
   then
   echo "Usage $0 sampleid inputdir"
exit 2
fi

set -o shwordsplit

source ~/.zshrc

# Files and folders
sampleid=$1
inputdir=$2
outabu="/Volumes/Temp/Robert/eecold/data/deviate/results/$sampleid/rpm"
outbamall="/Volumes/Temp/Robert/eecold/data/deviate/results/$sampleid/bam"
tmpdir="/Volumes/Temp/Robert/eecold/tmp"

## the REFERENCE 
refg="/Volumes/Temp/Robert/eecold/refg/teseq-scg-dsim/teseqs-scg-dsim.fasta"
hier="/Volumes/Temp/Robert/eecold/refg/teseq-scg-dsim/teseqs.hier"

# software
samtools="/Volumes/Temp/Robert/teminer/bin/samtools"
bwa="/Volumes/Temp/Robert/teminer/bin/bwa"
popte2="/Volumes/Temp/Robert/teminer/bin/popte2.jar"
readtorpm="/Volumes/Temp/Robert/teminer/bin/readstat2rpm_all.py"

mkdir -p $outabu
mkdir -p $outbamall
# paths
for read1 in $inputdir/*.fq.gz
do
	tmp=`basename $read1`
        readid=${tmp%.fq.gz}

        # mapping
	bamfile="$tmpdir/$readid.sort.bam"
	command="$bwa bwasw -t 8 -M $refg $read1 | $samtools view -Sb - | $samtools sort -T $sraid.nnnn.bam -O bam -m 4G > $bamfile"
	echo "executing mapping $command"
	eval $command
 
	# TE bam
	allbamfile="$outbamall/$readid.allte.sort.bam"
	samtools view -b -F 0x004 $bamfile > $allbamfile
	
	# PopoolationTE2
	opteabu="$outabu/$readid.rawabu"
	opterpm="$outabu/$readid.rpm"
	echo "Writting raw abundance to $opteabu"
	java -jar $popte2 stat-reads --bam $bamfile --map-qual 10 --hier $hier --output $opteabu
	echo "Writting rpm to $opterpm"
	python $readtorpm --rs $opteabu > $opterpm 

	# Cleanup tmp
        rm $bamfile
done 
