library(ggplot2)
library(gridExtra)

theme_set(theme_bw())
c<-read.table("/Users/rokofler/analysis/ee-cold-silencing/analysis/2020-smallRNA/03-length-distribution/grap-lengdistri/lendistri.forR")


# g22	r11	P	s	P-s	19	3	3.37078651685
# g22	r11	P	s	P-s	20	5	5.61797752809

names(c)<-c("generation","replicate","feature","strand","strandfeature","length","count","ncount")
c$replicate<-as.factor(c$replicate)
c$generation<-as.factor(c$generation)

gc<-ggplot(c,aes(x=length,y=ncount,group=strandfeature,fill=strand))+
geom_bar(stat="identity",position="identity")+
facet_grid(generation~replicate)+ylab("percent")+theme(legend.position="none")+xlim(18.5,29.5)



postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2020-smallRNA/03-length-distribution/grap-lengdistri/lendistri.ps",width=8,height=10)
plot(gc)
dev.off()
