library(ggplot2)
library(gridExtra)
theme_set(theme_bw())
palete <- c("darkgrey","red")

d<-read.table("/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/raw-insertions/core-info/teinsetions.withclusterannotation.txt")
#cold	3	0	4	1	-0.1	0
#cold	3	0	4	1400000	-0.1	0
#cold	5	0	4	1	-0.1	0
names(d)<-c("temp","replicate","generation","chromosome","position","popfreq","cluster")
d<-subset(d,chromosome=="X" |chromosome=="2L"|chromosome=="2R"|chromosome=="3L"|chromosome=="3R"|chromosome=="4")


# convert chromosome to ordered factor
d$cluster<-as.factor(d$cluster)
d$size=2
d[d$popfreq==-0.1,]$size=10
d[d$cluster==1,]$size=3
d$chromosome <- factor(d$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))

lim<-c(0.0,0.5)
ybreaks<-c(0,0.1, 0.2,0.3, 0.4,0.5)
c<-subset(d,temp=="cold")
c<-subset(c,generation==0 | generation==30 | generation==40 | generation==50 | generation==70 | generation==80 | generation==90 | generation==100)
h<-subset(d,temp=="hot")

ph1<- ggplot(h[h$replicate==1,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
ph3<- ggplot(h[h$replicate==3,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
ph5<- ggplot(h[h$replicate==5,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")

pc1<- ggplot(c[c$replicate==1,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
pc3<- ggplot(c[c$replicate==3,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
pc5<- ggplot(c[c$replicate==5,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")









setEPS(horizontal = FALSE, onefile = FALSE, paper = "special")
postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/graphs/mhp-hot-r1.ps",width=10,height=7)
plot(ph1)
dev.off()
postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/graphs/mhp-hot-r3.ps",width=10,height=7)
plot(ph3)
dev.off()
postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/graphs/mhp-hot-r5.ps",width=10,height=7)
plot(ph5)
dev.off()


postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/graphs/mhp-cold-r1.ps",width=10,height=8)
plot(pc1)
dev.off()
postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/graphs/mhp-cold-r3.ps",width=10,height=8)
plot(pc3)
dev.off()
postscript(file="/Users/rokofler/analysis/ee-cold-silencing/analysis/2021-02-popte2/graphs/mhp-cold-r5.ps",width=10,height=8)
plot(pc5)
dev.off()




