library(ggplot2)
library(RColorBrewer)
theme_set(theme_bw())

b<-brewer.pal(12,"Paired")
fuckit<-c("grey50","#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#a65628","#f781bf")
cbbPalette<-fuckit

t<-read.table("/Users/rokofler/analysis/ee-cold-silencing/analysis/2020-smallRNA/04-family-distribution/data/rawdata-for-r.txt")
# cold	1	22	1360	3409	3869	1508.69498079
# cold	1	22	412	7567	29434	11477.624209
# cold	1	22	ACCORD	7404	5371	2094.39150732

names(t)<-c("condition","replicate","generation","family","leng","count","normc","normppm")
t<-t[t$family=="PPI251",]
t$replicate=as.factor(t$replicate)

t$condition<-factor(t$condition,levels=c("hot","cold"))
#t <- rbind(t[t$family!="PPI251",], t[t$family=="PPI251",])
# t <- rbind(t[t$family!="Mariner",], t[t$family=="Mariner",])
# t <- rbind(t[t$family!="blood",], t[t$family=="blood",])
# t <- rbind(t[t$family!="pogo",], t[t$family=="pogo",])
# t <- rbind(t[t$family!="Transpac",], t[t$family=="Transpac",])
# t <- rbind(t[t$family!="hopper",], t[t$family=="hopper",])
# t <- rbind(t[t$family!="BS",], t[t$family=="BS",])





g<-ggplot()+geom_line(data=t,aes(x=generation,y=normppm,color=replicate))+ylab("piRNA abundance (per million miRNA")+xlim(0,80)
# +theme(legend.position="none")

#pdf(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-08-piRNA/graph/pirnadevelopment-pub.pdf",width=6,height=3.7)
plot(g)
#dev.off()


# names(t)<-c("condition","replicate","generation","family","leng","count","normc")
#pihot<-aggregate(normc~family,data=subset(t,condition=="hot"),FUN=mean)
#picold<-aggregate(normc~family,data=subset(t,condition=="cold"),FUN=mean)
#print(quantile(pihot$normc))
#print(quantile(picold$normc))
#p=subset(t,family=="PPI251")
#print(p)