library(ggplot2)

theme_set(theme_bw())
h<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-08-piRNA/stat-distri-mm2/composite/hot.txt")
names(h)<-c("rep","time","pps","pos","pirna")
h$time<-as.factor(h$time)
h<-subset(h,pps=="s")

ylow=-2000
yhigh=max(h$pirna)

h[h$pirna < ylow,]$pirna<- ylow
#h[h$pirna > yhigh,]$pirna<- yhigh

p<- ggplot(h,aes(x=pos,y=pirna))+geom_segment(aes(xend=pos),yend=0)+facet_grid(time~rep)+ylim(ylow,yhigh)+ylab("piRNA abundance (per million miRNA)")+xlab("position of piRNA (5' end)")


postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-08-piRNA/stat-distri-mm2/graphs/hot-pirnas-distribution.ps",width=10,height=10)

plot(p)
dev.off



h<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-08-piRNA/stat-distri-mm2/composite/cold.txt")
names(h)<-c("rep","time","pps","pos","pirna")
h$time<-as.factor(h$time)
h<-subset(h,pps=="s")

ylow=-2000
yhigh=max(h$pirna)

h[h$pirna < ylow,]$pirna<- ylow
#h[h$pirna > yhigh,]$pirna<- yhigh

p<- ggplot(h,aes(x=pos,y=pirna))+geom_segment(aes(xend=pos),yend=0)+facet_grid(time~rep)+ylim(ylow,yhigh)+ylab("piRNA abundance (per million miRNA)")+xlab("position of piRNA (5' end)")


postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-08-piRNA/stat-distri-mm2/graphs/cold-pirnas-distribution.ps",width=10,height=5.5)

plot(p)
dev.off()