#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import collections




def loadclusterinsertions(file):
    # allcold	U_21	41000	41500	4.9996698658
    # allcold	U_21	42000	42500	4.2284604245
    toret=collections.defaultdict(lambda: [])
    for l in open(file):
        a=l.rstrip("\n").split("\t")
        chrm,start,end,score=a[1],int(a[2]),int(a[3]),float(a[4])
        toret[chrm].append((start,end))
    return(toret)


            
    


parser = argparse.ArgumentParser(description="""           
Description
-----------
    This script simulates single-end reads from the population genome""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")


parser.add_argument("--cluster", type=str, required=True, dest="cluster", default=None, help="binsize")
parser.add_argument("--teinsertions", type=str, required=True, dest="teinsertions", default=None, help="binsize")
args = parser.parse_args()

clusters=loadclusterinsertions(args.cluster)


for l in open(args.teinsertions):
    """
    0       1   2   3   4   5
    cold	1	0	4	1	-0.1
    cold	1	0	4	1400000	-0.1

    """
    l=l.rstrip("\n")
    a=l.split("\t")
    chrm,pos=a[3],int(a[4])    
    isclusterinsert=0
    clusterlist=clusters[chrm]
    for start,end in clusterlist:
        if pos>=start and pos<=end:
            isclusterinsert=1
    print l+"\t"+str(isclusterinsert)
        
    