import sys


"""
usage:
python compute-summary.py g22-r11.nucs15-35.overview.stat



input:
g22-r11.nucs15-35	gen	unmapped	7665902	-
g22-r11.nucs15-35	gen	pseudounmapped	14978	-
g22-r11.nucs15-35	gen	tecount	874933	656810
g22-r11.nucs15-35	gen	mirnacount	2564468	70
g22-r11.nucs15-35	gen	trnacount	592804	63
g22-r11.nucs15-35	gen	rrnacount	450299	106
g22-r11.nucs15-35	gen	mrnacount	544933	131076
g22-r11.nucs15-35	teabundance	RT1C	24644	18024

output:
my supplementary table 5 of Genome Research paper

i.e. produces an overview of the small RNA libraries
"""
asch={} # anti-sense count hash
sch={} # sense count hash
mappedcount=0
totcount=0
sid=None
d=1000000.0

for l in open(sys.argv[1]):
    a=l.rstrip("\n").split("\t")
    key=a[1]
    if key!="gen":
        continue
    sid=a[0]
    feature=a[2]
    
    count=int(a[3])
    totcount+=count
    
    if feature=="unmapped" or feature =="pseudounmapped":
        pass
    elif feature=="tecount" or feature=="mirnacount" or feature=="trnacount" or feature =="rrnacount" or feature == "mrnacount":    
        ascount=int(a[4])
        mappedcount+=count
        sch[feature]=count
        asch[feature]=ascount

topr=[sid]
topr.append("{:.2f}".format(float(totcount)/d))
topr.append("{:.2f}".format(float(mappedcount)/d))
topr.append("{:.2f}".format(100.0*float(sch["tecount"])/float(mappedcount)))
topr.append("{:.2f}".format(100.0*float(sch["mirnacount"])/float(mappedcount)))
topr.append("{:.2f}".format(100.0*float(sch["trnacount"])/float(mappedcount)))
topr.append("{:.2f}".format(100.0*float(sch["rrnacount"])/float(mappedcount)))
topr.append("{:.2f}".format(100.0*float(sch["mrnacount"])/float(mappedcount)))
topr.append("{:.2f}".format(100.0-(100.0*float(asch["tecount"])/float(sch["tecount"]))))
topr.append("{:.2f}".format(100.0-(100.0*float(asch["mirnacount"])/float(sch["mirnacount"]))))
topr.append("{:.2f}".format(100.0-(100.0*float(asch["trnacount"])/float(sch["trnacount"]))))
topr.append("{:.2f}".format(100.0-(100.0*float(asch["rrnacount"])/float(sch["rrnacount"]))))
topr.append("{:.2f}".format(100.0-(100.0*float(asch["mrnacount"])/float(sch["mrnacount"]))))



tp=" ".join(topr)
print(tp)


#"{:.2f}".format(num)


    