#!/usr/bin/env python

"""This script is used to parse the results of FIMO
Usage: %prog <FIMO_result> | sort -k1,1 -k2,n2 | uniq > <output_file>
"""

import re
import gzip
import sys


def open_file(in_file='', mode='r'):
    if re.search('.gz$', in_file):
        mode += 't'
        return gzip.open(in_file, mode=mode)
    return open(in_file, mode=mode)


def parse_fimo(fimo_out='', pvalue_thresh=0.05):
    with open_file(fimo_out) as fh:
        for line in fh:
            line = line.strip()
            if not line or re.search('^motif_id', line) or re.search('^#', line):
                continue
            lineL = line.split('\t')
            rbp_motif, region, m_start, m_end, p_value = lineL[1], lineL[2], int(
                lineL[3]), int(lineL[4]), float(lineL[7])
            region = region.split('_')
            if p_value >= pvalue_thresh:
                continue
            chr, i_start, i_end, strand, sub = region[0], int(
                region[1]), int(region[2]), region[3], '_'.join(region[4:])
            intron_id = '_'.join(region[:4])
            if strand == "+":
                start = int(i_start) + m_start - 1
                end = int(i_start) + m_end
            elif strand == "-":
                start = int(i_end) - m_end
                end = int(i_end) - m_start + 1
            print('\t'.join([chr, str(start), str(end)]))


def main():
    try:
        FIMO_result = sys.argv[1]
        p_cutoff = float(sys.argv[2])
    except:
        sys.exit(__doc__)
    parse_fimo(FIMO_result, p_cutoff)


if __name__ == '__main__':
    main()

