################################################################################
#################################### svm #######################################
################################################################################
source("src/tdd_analysis_load.R")

svm_fit <- tdd_index %>%
  svm(
    tdd_index ~ .,
    data = .,
    scale = T,
    type = "eps-regression",
    kernel = "radial",
    shrinking = T,
    cross = 10
  )
save(svm_fit,
     file = "results/svm_fit.Rdata")
load(file = "results/svm_fit.Rdata")

rmse <- function(error) {
  sqrt(mean(error^2))
}

svm_pred <- predict(
  svm_fit,
  tdd_index %>%
    dplyr::select(-tdd_index)
  )
rmse(tdd_index %>% dplyr::pull(tdd_index) - svm_pred)

tunesvm <- tdd_index %>%
  tune(svm, 
    tdd_index ~ .,
    data = .,
    scale = T,
    type = "eps-regression",
    kernel = "radial",
    shrinking = T,
    ranges = list(epsilon = seq(0,1,0.1), cost = 2^(2:9))
)
save(tunesvm,
     file = "results/svm_tune.Rdata")
load(file = "results/svm_tune.Rdata")

svm_predictor = Predictor$new(
  svm_fit,
  data = tdd_index %>%
    dplyr::select(-tdd_index),
  y = tdd_index %>%
    dplyr::pull(-tdd_index)
  )
save(svm_predictor,
     file = "results/svm_predictor.Rdata")
save(tdd_index, svm_fit, svm_predictor,
     file = "results/svm_model.Rdata")


# compute Feature importance
load(file = "results/svm_model.Rdata")
svm_imp = FeatureImp$new(svm_predictor, loss = "mse")
save(svm_imp,
     file = "results/svm_imp.Rdata")
load(file = "results/svm_imp.Rdata")
plot(svm_imp)

# compute Feature effects
load(file = "results/svm_model.Rdata")
svm_ale <- list()
for (feature in svm_imp$results %>%
     dplyr::filter(importance >= 1) %>%
     dplyr::pull(feature) %>% as_vector()) {
  svm_ale[[feature]] <-
    FeatureEffect$new(svm_predictor, feature = feature)
}
save(svm_ale,
     file = "results/svm_ale.Rdata")
load(file = "results/svm_ale.Rdata")

for (feature in names(svm_ale)) {
  plot(svm_ale[[feature]])
}

# compute interaction of any feature with others
load(file = "results/svm_model.Rdata")
svm_interact = Interaction$new(svm_predictor)
save(svm_interact,
     file = "results/svm_interact.Rdata")
load(file = "results/svm_interact.Rdata")
plot(svm_interact)


# feature effects for all features at once:
load(file = "results/svm_model.Rdata")
svm_effs = FeatureEffects$new(svm_predictor)
save(svm_effs,
     file = "results/svm_effs.Rdata")
load(file = "results/svm_effs.Rdata")
plot(svm_effs)