########################################
######        plot any gene       ######
######         2018.01.25         ######
########################################

setwd("~/GoogleDrive/Post-Doc_ENS/Documents/RMI2/Projet_TDD/20180122_Normalisation/01_Normalisation")
library(ggplot2)
theme_set(theme_bw())
library(dplyr)
library(stringr)

load("01_dbNormCountsAll_exon.RData")
load("../07_ActivatedTDD_vs_RestingTDD/07_IndexTDDallConditions_v3.RData")

names(IndexTDD) = c("LymphoResting", "LymphoActivated", "macroResting", "macroActivated")

gene = "ENSMUSG00000055994.14"
cell = "macro" # Lympho ou macro


data_resting = dball[dball$cell==cell&
               dball$`Activated/Resting`=="Resting"&
               dball$ensemblID==gene&
               (dball$treatment=="Trip"|dball$treatment=="TripCHX"),]
data_resting = group_by(data_resting, ensemblID, time, treatment)
data_resting = summarise(data_resting, mean = mean(normReadsCounts), sem = sd(normReadsCounts)/sqrt(length(unique(replicate))))
data_resting$time = as.numeric(str_extract(data_resting$time, "."))
data_resting <- rbind(data_resting, data_resting[1,])
data_resting[nrow(data_resting),"treatment"] <- "TripCHX"

data_activated = dball[dball$cell==cell&
                       dball$`Activated/Resting`=="Activated"&
                       dball$ensemblID==gene&
                       (dball$treatment=="Trip"|dball$treatment=="TripCHX"),]
data_activated = group_by(data_activated, ensemblID, time, treatment)
data_activated = summarise(data_activated, mean = mean(normReadsCounts), sem = sd(normReadsCounts)/sqrt(length(unique(replicate))))
data_activated$time = as.numeric(str_extract(data_activated$time, "."))
data_activated <- rbind(data_activated, data_activated[1,])
data_activated[nrow(data_activated),"treatment"] <- "TripCHX"

tddIndex_resting = round(mean(IndexTDD[[paste0(cell,"Resting")]][IndexTDD[[paste0(cell,"Resting")]]$ensemblID==gene,"IndexTDD_t3TripTripCHX"], na.rm=TRUE), digit = 2)
tddIndex_activated = round(mean(IndexTDD[[paste0(cell,"Activated")]][IndexTDD[[paste0(cell,"Activated")]]$ensemblID==gene,"IndexTDD_t3TripTripCHX"], na.rm=TRUE), digit = 2)

library(grid)
grob <- grobTree(textGrob(paste("TDD index in resting cells : ",tddIndex_resting,"\nTDD index in activated cells : ", tddIndex_activated), x=0.1,  y=0.95, hjust=0,
                          gp=gpar(col="blue", fontsize=13, fontface="italic")))

ggplot() + 
  geom_point(data = data_resting, aes(x = time, y = mean, colour = treatment), alpha = 1, shape = 1) + 
  geom_point(data = data_activated, aes(x = time, y = mean, colour = treatment), alpha = 1, shape = 3) + 
  geom_line(data = data_resting, aes(x = time, y = mean, colour = treatment)) + 
  geom_line(data = data_activated, aes(x = time, y = mean, colour = treatment)) +
  geom_linerange(data = data_resting, aes(x = time, ymax=(mean+sem), ymin = (mean-sem)) ) + 
  xlab ("Time (h)") + ylab ("Relative abundance") + ggtitle (paste(gene, "in", cell)) + 
  annotation_custom(grob)

