## figure paper
library(ggplot2)
library(tidyverse)
library(reshape2)
theme_set(theme_bw())

setwd("~/RMI2/Projet_TDD/20200114_Normalisation")
load("results/database.RData")

color_resting = "#69b3a2"
color_activated = "#404080"
color_1h = "deepskyblue"
color_3h = "darkmagenta"
# mRNA degradation density ------------------------------------------------

pdf("final_fig/fig_degradationDensity.pdf", width = 8)
data <- table %>% select(Deg1hTrip_LR, Deg3hTrip_LR)
colnames(data) <- c("at 1h", "at 3h")
data <- melt(data)
ggplot(data = data, aes(x = value)) + 
  geom_histogram(aes(y=..density.., fill = variable), alpha = 0.75, binwidth = .015, position = "identity") +
  geom_density(alpha=0.6, position = "identity",aes(color = variable), size = 1)  + 
  xlim(-0.5,1.2) + 
  xlab("fraction of mRNA degradation") + 
  scale_fill_manual(values=c(color_1h, color_3h)) +
  scale_color_manual(values=c(color_1h, color_3h)) + 
  ggtitle("Lymphocyte resting Triptolide") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        panel.background = element_blank(), axis.line = element_line(colour = "black"))



data <- table %>% select(Deg1hTrip_LA, Deg3hTrip_LA)
colnames(data) <- c("at 1h", "at 3h")
data <- melt(data)
ggplot(data = data, aes(x = value)) + 
  geom_histogram(aes(y=..density.., fill = variable), alpha = 0.75, binwidth = .015, position = "identity") +
  geom_density(alpha=0.6, position = "identity",aes(color = variable), size = 1)  + 
  xlim(-0.5,1.2) + 
  xlab("fraction of mRNA degradation") + 
  scale_fill_manual(values=c(color_1h, color_3h)) +
  scale_color_manual(values=c(color_1h, color_3h)) + 
  ggtitle("Lymphocyte activated Triptolide") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        panel.background = element_blank(), axis.line = element_line(colour = "black"))


data <- table %>% select(Deg1hTrip_LR, Deg1hTrip_LA)
colnames(data) <- c("Resting", "Activated")
data <- melt(data)
ggplot(data = data, aes(x = value)) + 
  geom_histogram(aes(y=..density.., fill = variable), alpha = 0.75, binwidth = .015, position = "identity") +
  geom_density(alpha=0.6, position = "identity",aes(color = variable), size = 1)  + 
  xlim(-0.5,1.2) + 
  xlab("fraction of mRNA degradation") + 
  scale_fill_manual(values=c(color_resting, color_activated)) +
  scale_color_manual(values=c(color_resting, color_activated)) + 
  ggtitle("Lymphocyte Triptolide at 1h") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        panel.background = element_blank(), axis.line = element_line(colour = "black"))

data <- table %>% select(Deg3hTrip_LR, Deg3hTrip_LA)
colnames(data) <- c("Resting", "Activated")
data <- melt(data)
ggplot(data = data, aes(x = value)) + 
  geom_histogram(aes(y=..density.., fill = variable), binwidth = .015, position = "identity") +
  geom_density(alpha=0.6, position = "identity",aes(color = variable), size = 1)  + 
  xlim(-0.5,1.2) + 
  xlab("fraction of mRNA degradation") + 
  scale_fill_manual(values=alpha(c(color_resting, color_activated), 0.75)) +
  scale_color_manual(values=c(color_resting, color_activated)) + 
  ggtitle("Lymphocyte Triptolide at 3h") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        panel.background = element_blank(), axis.line = element_line(colour = "black"))

dev.off()



# correlation replicate (row counts) --------------------------------------

all_data=read.delim("data/HTSeq_count_stats_all_libraries.csv", header=TRUE, sep=",", row.names=1, stringsAsFactors = TRUE) 
all_data <- all_data[grep(pattern = "ENS.*", rownames(all_data)),]
pdf("final_fig/fig_replicats.pdf")


var1 <- c("R2_4_Resting_0h_Triptolide_exon", "R2_4_Resting_0h_Triptolide_exon", "R3_4_Resting_0h_Triptolide_exon",
          "R2_5_Resting_1h_Triptolide_exon", "R2_5_Resting_1h_Triptolide_exon", "R3_5_Resting_1h_Triptolide_exon",
          "R2_6_Resting_3h_Triptolide_exon", "R2_6_Resting_3h_Triptolide_exon", "R3_6_Resting_3h_Triptolide_exon",
          "R2_11_Resting_1h_Triptolide_CHX_exon", "R2_11_Resting_1h_Triptolide_CHX_exon", "R3_11_Resting_1h_Triptolide_CHX_exon",
          "R2_12_Resting_3h_Triptolide_CHX_exon", "R2_12_Resting_3h_Triptolide_CHX_exon", "R3_12_Resting_3h_Triptolide_CHX_exon", 
          "R2_13_Resting_1h_Triptolide_Harr_exon", "R2_13_Resting_1h_Triptolide_Harr_exon", "R3_13_Resting_1h_Triptolide_Harr_exon",
          "R2_14_Resting_3h_Triptolide_Harr_exon", "R2_14_Resting_3h_Triptolide_Harr_exon", "R3_14_Resting_3h_Triptolide_Harr_exon")

var2 <- c("R3_4_Resting_0h_Triptolide_exon", "R4_4_Resting_0h_Triptolide_exon", "R4_4_Resting_0h_Triptolide_exon",
          "R3_5_Resting_1h_Triptolide_exon", "R4_5_Resting_1h_Triptolide_exon", "R4_5_Resting_1h_Triptolide_exon",
          "R3_6_Resting_3h_Triptolide_exon", "R4_6_Resting_3h_Triptolide_exon", "R4_6_Resting_3h_Triptolide_exon",
          "R3_11_Resting_1h_Triptolide_CHX_exon", "R4_11_Resting_1h_Triptolide_CHX_exon", "R4_11_Resting_1h_Triptolide_CHX_exon",
          "R3_12_Resting_3h_Triptolide_CHX_exon", "R4_12_Resting_3h_Triptolide_CHX_exon", "R4_12_Resting_3h_Triptolide_CHX_exon",
          "R3_13_Resting_1h_Triptolide_Harr_exon", "R4_13_Resting_1h_Triptolide_Harr_exon", "R4_13_Resting_1h_Triptolide_Harr_exon",
          "R3_14_Resting_3h_Triptolide_Harr_exon", "R4_14_Resting_3h_Triptolide_Harr_exon", "R4_14_Resting_3h_Triptolide_Harr_exon")

legend1_1 <- rep(c("replicate 1", "replicate 1", "replicate 2" ), times = 7)
legend1_2 <- rep(c("replicate 2", "replicate 3", "replicate 3" ), times = 7)

legend2 <- c(rep("0h", times = 3), 
             rep("1h", times = 3), 
             rep("3h", times = 3), 
             rep("1h", times = 3), 
             rep("3h", times = 3), 
             rep("1h", times = 3), 
             rep("3h", times = 3) 
            )
legend3 <- c(rep("Triptolide", times = 9),
             rep("Triptolide + CHX", times = 6),
             rep("Triptolide + Harr", times = 6)
           )

for (i in 1:length(var1)) {
  data <- all_data %>% select(var1[i], var2[i]) %>% as.data.frame()
  rsq <- round(cor(x= data[,1], y = data[,2]),
               digit = 3)
  p1 <- ggplot(data = data,aes(x = log(data[,var1[i]]), log(data[,var2[i]]))) +
    geom_point(alpha = 0.5, color = color_resting  ) +
    geom_text(x = 1, y = 9, label=paste("r = ", rsq), size = 5) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), axis.line = element_line(colour = "black")) +
    xlab(paste("lymphocytes resting", legend2[i], legend3[i],  legend1_1[i], "- (log(counts))")) + 
    ylab(paste("lymphocytes resting", legend2[i], legend3[i],  legend1_2[i], "- (log(counts))")) +
    xlim(0,11) + ylim(0,11)
  
  print(p1)
}

var1 <- c("A2_7_Activated_0h_Triptolide_exon", "A2_7_Activated_0h_Triptolide_exon", "A3_7_Activated_0h_Triptolide_exon",
          "A2_8_Activated_1h_Triptolide_exon", "A2_8_Activated_1h_Triptolide_exon", "A3_8_Activated_1h_Triptolide_exon",
          "A2_9_Activated_3h_Triptolide_exon", "A2_9_Activated_3h_Triptolide_exon", "A3_9_Activated_3h_Triptolide_exon",
          "A2_18_Activated_1h_Triptolide_CHX_exon", "A2_18_Activated_1h_Triptolide_CHX_exon", "A3_18_Activated_1h_Triptolide_CHX_exon",
          "A2_19_Activated_3h_Triptolide_CHX_exon", "A2_19_Activated_3h_Triptolide_CHX_exon", "A3_19_Activated_3h_Triptolide_CHX_exon", 
          "A2_20_Activated_1h_Triptolide_Harr_exon", "A2_20_Activated_1h_Triptolide_Harr_exon", "A3_20_Activated_1h_Triptolide_Harr_exon",
          "A2_21_Activated_3h_Triptolide_Harr_exon", "A2_21_Activated_3h_Triptolide_Harr_exon", "A3_21_Activated_3h_Triptolide_Harr_exon",
          "A2_4_Activated_0h_DRB_exon", "A2_4_Activated_0h_DRB_exon", "A3_4_Activated_0h_DRB_exon",
          "A2_5_Activated_1h_DRB_exon", "A2_5_Activated_1h_DRB_exon", "A3_5_Activated_1h_DRB_exon",
          "A2_6_Activated_3h_DRB_exon", "A2_6_Activated_3h_DRB_exon", "A3_6_Activated_3h_DRB_exon",
          "A2_14_Activated_1h_DRB_CHX_exon", "A2_14_Activated_1h_DRB_CHX_exon", "A3_14_Activated_1h_DRB_CHX_exon",
          "A2_15_Activated_3h_DRB_CHX_exon", "A2_15_Activated_3h_DRB_CHX_exon", "A3_15_Activated_3h_DRB_CHX_exon",
          "A2_16_Activated_1h_DRB_Harr_exon", "A2_16_Activated_1h_DRB_Harr_exon", "A3_16_Activated_1h_DRB_Harr_exon",
          "A2_17_Activated_3h_DRB_Harr_exon", "A2_17_Activated_3h_DRB_Harr_exon", "A3_17_Activated_3h_DRB_Harr_exon")

var2 <- c("A3_7_Activated_0h_Triptolide_exon", "A4_7_Activated_0h_Triptolide_exon", "A4_7_Activated_0h_Triptolide_exon",
          "A3_8_Activated_1h_Triptolide_exon", "A4_8_Activated_1h_Triptolide_exon", "A4_8_Activated_1h_Triptolide_exon",
          "A3_9_Activated_3h_Triptolide_exon", "A4_9_Activated_3h_Triptolide_exon", "A4_9_Activated_3h_Triptolide_exon",
          "A3_18_Activated_1h_Triptolide_CHX_exon", "A4_18_Activated_1h_Triptolide_CHX_exon", "A4_18_Activated_1h_Triptolide_CHX_exon",
          "A3_19_Activated_3h_Triptolide_CHX_exon", "A4_19_Activated_3h_Triptolide_CHX_exon", "A4_19_Activated_3h_Triptolide_CHX_exon",
          "A3_20_Activated_1h_Triptolide_Harr_exon", "A4_20_Activated_1h_Triptolide_Harr_exon", "A4_20_Activated_1h_Triptolide_Harr_exon",
          "A3_21_Activated_3h_Triptolide_Harr_exon", "A4_21_Activated_3h_Triptolide_Harr_exon", "A4_21_Activated_3h_Triptolide_Harr_exon",
          "A3_4_Activated_0h_DRB_exon", "A4_4_Activated_0h_DRB_exon", "A4_4_Activated_0h_DRB_exon",
          "A3_5_Activated_1h_DRB_exon", "A4_5_Activated_1h_DRB_exon", "A4_5_Activated_1h_DRB_exon",
          "A3_6_Activated_3h_DRB_exon", "A4_6_Activated_3h_DRB_exon", "A4_6_Activated_3h_DRB_exon",
          "A3_14_Activated_1h_DRB_CHX_exon", "A4_14_Activated_1h_DRB_CHX_exon", "A4_14_Activated_1h_DRB_CHX_exon",
          "A3_15_Activated_3h_DRB_CHX_exon", "A4_15_Activated_3h_DRB_CHX_exon", "A4_15_Activated_3h_DRB_CHX_exon",
          "A3_16_Activated_1h_DRB_Harr_exon", "A4_16_Activated_1h_DRB_Harr_exon", "A4_16_Activated_1h_DRB_Harr_exon",
          "A3_17_Activated_3h_DRB_Harr_exon", "A4_17_Activated_3h_DRB_Harr_exon", "A4_17_Activated_3h_DRB_Harr_exon")

legend1_1 <- rep(c("replicate 1", "replicate 1", "replicate 2" ), times = 14)
legend1_2 <- rep(c("replicate 2", "replicate 3", "replicate 3" ), times = 14)

legend2 <- rep(c(rep("0h", times = 3), 
                 rep("1h", times = 3), 
                 rep("3h", times = 3), 
                 rep("1h", times = 3), 
                 rep("3h", times = 3), 
                 rep("1h", times = 3), 
                 rep("3h", times = 3)), 
                times = 2)
legend3 <- c(rep("Triptolide", times = 9),
             rep("Triptolide + CHX", times = 6),
             rep("Triptolide + Harr", times = 6),
             rep("DRB", times = 9),
             rep("DRB + CHX", times = 6),
             rep("DRB + Harr", times = 6)
)

for (i in 1:length(var1)) {
  data <- all_data %>% select(var1[i], var2[i]) %>% as.data.frame()
  rsq <- round(cor(x= data[,1], y = data[,2]),
               digit = 3)
  p1 <- ggplot(data = data,aes(x = log(data[,var1[i]]), log(data[,var2[i]]))) +
    geom_point(alpha = 0.5, color = color_activated  ) +
    geom_text(x = 1, y = 9, label=paste("r = ", rsq), size = 5) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), axis.line = element_line(colour = "black")) +
    xlab(paste("lymphocytes activated", legend2[i], legend3[i],  legend1_1[i], "- (log(counts))")) + 
    ylab(paste("lymphocytes activated", legend2[i], legend3[i],  legend1_2[i], "- (log(counts))")) +
    xlim(0,11) + ylim(0,11)
  
  print(p1)
}

dev.off()
