#######################################
### Diff trad genes ###################
#######################################

if (!requireNamespace("BiocManager", quietly = TRUE))
  install.packages("BiocManager")

BiocManager::install("DESeq2")

pks <- list('ggplot2' , 'tidyverse' , 'DESeq2' , 'reshape2', 'stringr', 'gridExtra')
lapply(pks , library , character.only = T, quietly = FALSE)

theme_set(theme_bw())

# 1. Choose file

setwd("~/RMI2/Projet_TDD/20200114_Normalisation")

RNAseqFile = "data/HTSeq_count_stats_all_libraries.csv"
RiboseqFile = "data/RiboProf_counts_stats.df"

###################################### LYMPHOCYTES ##########################################
#2. Read the data with header and row names

RNAseq_data <- read.delim(
  file = RNAseqFile,
  header = TRUE,
  sep = ",",
  row.names = 1,
  stringsAsFactors = TRUE
)

## clear data
RNAseq_data <-
  RNAseq_data[grep("ENSMUSG.*", rownames(RNAseq_data)), grep(".*0h_Triptolide_CDS$", colnames(RNAseq_data))]

rnRSd <- rownames(RNAseq_data)
RNAseq_data <-
  apply(RNAseq_data, 2, function(x)
    as.numeric(as.integer(x)))
rownames(RNAseq_data) <- rnRSd

RiboSeq_data <- read.delim(
  file = RiboseqFile,
  header = TRUE,
  sep = "\t",
  row.names = 1,
  stringsAsFactors = TRUE
)

RiboSeq_data <-
  RiboSeq_data[grep("ENSMUSG.*", rownames(RiboSeq_data)), grep(".*(a|r)T._CDS$", colnames(RiboSeq_data))]
rnRSd <- rownames(RiboSeq_data)
RiboSeq_data <-
  apply(RiboSeq_data, 2, function(x)
    as.numeric(as.integer(x)))
rownames(RiboSeq_data) <- rnRSd

data <- cbind(RiboSeq_data, RNAseq_data)

for(i in 1:ncol(data)){
  for(j in 1:nrow(data)){
    if(is.na(data[j,i])){
      data[j,i] <- 0
    }
  }
}

### Paramètrage

colData = as.data.frame((colnames(data)))

conds = factor(c("activated", 
                 "resting", 
                 'activated', 
                 "resting",
                 'activated', 
                 "resting",
                 "resting",
                 "resting",
                 "resting",
                 "activated",
                 "activated",
                 "activated"))
sequencing = factor(c(rep("RiboSeq",6),
                      rep("RNAseq",6)
)
)
replicate = factor(c(1,
                     1,
                     2,
                     2,
                     3,
                     3,
                     3,
                     2,
                     1,
                     3,
                     2,
                     1))

colData <- cbind(colData, conds, sequencing, replicate)

colnames(colData) <-
  c("library", "condition", "sequencing", "replicate")

dds = DESeqDataSetFromMatrix(
  countData = as.matrix(data),
  colData = colData,
  design = ~ condition:sequencing + condition + replicate:sequencing
)
dds$condition <- relevel(dds$condition, "resting")
dds$sequencing <- relevel(dds$sequencing, "RNAseq")

dds <- DESeq(dds)
resultsNames(dds)
res <- results(
  dds,
  contrast = list(
    "conditionactivated.sequencingRiboSeq",
    "conditionresting.sequencingRiboSeq"
  )
)


table(res$padj < 0.05)
write.csv(res, file = "results/DESeqresults_lympho_activation.csv")

# 3. Check DESeq model  ---------------
library(RColorBrewer)
library(gplots)
pdf("results/DESeq_model_Lympho.pdf")

rld <- rlogTransformation(dds, blind=TRUE)
vsd <- varianceStabilizingTransformation(dds, blind=TRUE)

ylim <- c(-10,10)
drawLines <- function() abline(h=c(-.4,.4),col="dodgerblue",lwd=2)
plotPCA(rld)
plotDispEsts(dds)
sampleDists <- dist( t( assay(rld) ) )
sampleDistMatrix <- as.matrix( sampleDists )
colours = colorRampPalette( rev(brewer.pal(9, "Blues")) )(255)
heatmap.2(sampleDistMatrix, trace="none", col=colours, cexRow = 0.8, cexCol = 0.8)

dev.off()

summary(res)
plotMA(res, alpha = 0.05)

diff_gene <- res[!is.na(res$padj) & res$padj < 0.05,]
up_genes <- res[!is.na(res$padj) & res$padj < 0.05 & res$log2FoldChange > 0,]
down_genes <- res[!is.na(res$padj) & res$padj < 0.05 & res$log2FoldChange < 0,]

# 4. IndexTDDas of diff genes ---------------------------------------------

load(file = "results/database.RData")
TDDindexes <- dplyr::select(table, 
                            "EnsemblID", 
                            "asIndexTDD_t3TripTripCHX.0hTrip_LR",
                            "asIndexTDD_t3TripTripCHX.0hTrip_LA", 
                            "RiboDens_LymphoR",
                            "RiboDens_LymphoA", 
                            "Length.cds",
                            "Deg3hTrip_LR",
                            "Deg3hTrip_LA"
)
TDDindexes$RiboDens_LymphoR <- as.numeric(as.character(TDDindexes$RiboDens_LymphoR))
TDDindexes$RiboDens_LymphoA <- as.numeric(as.character(TDDindexes$RiboDens_LymphoA))
colnames(TDDindexes) <- c("ensemblID", "asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA", "Length.cds", "Deg3h_LR", "Deg3h_LA")


pdf(file = "results/Ribdens_vs_CDS_Length.pdf")
ggplot(data = TDDindexes, aes(x = RiboDens_LymphoR, y = Length.cds)) + 
  geom_point(alpha = 0.5) + 
  scale_y_log10() + scale_x_log10() + 
  xlab("log10(Density of Ribosomes in resting lymphocytes") + ylab("log10(CDS length")

ggplot(data = TDDindexes, aes(x = RiboDens_LymphoA, y = Length.cds)) + 
  geom_point(alpha = 0.5) + 
  scale_y_log10() + scale_x_log10() + 
  xlab("log10(Density of Ribosomes in activated lymphocytes") + ylab("log10(CDS length)")
dev.off()

pdf("results/TDDindex_of_diff_translated_genes.pdf",
    width = 8.5,
    height = 11)
# Diff genes (up + down)
diff_gene = as.data.frame(cbind(rownames(diff_gene), diff_gene))
colnames(diff_gene)[1] <- "ensemblID"
diff_gene$ensemblID <- str_extract(diff_gene$ensemblID, "ENSMUSG...........")
diff_gene <- merge(diff_gene, TDDindexes, by = "ensemblID")

gdata <- melt(diff_gene[,c(1,2,3,8:11)], measure.vars = c("asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA"))
gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] <- gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] * 2 ^ gdata[gdata$variable == "asTDDindex_LymphoA", "log2FoldChange"]

p1 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = value)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("absolute TDD index") +
  geom_boxplot(width = 0.1) + ggtitle("IndexTDDas (3hCHX) of up + down - translated genes ")

p2 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = baseMean)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("log10(Ribosome occupancy)") +
  geom_boxplot(width = 0.1) + scale_y_log10() + ggtitle("RiboDens of uptranslated genes ")

grid.arrange(p1, p2, ncol = 2) 

up_genes = as.data.frame(cbind(rownames(up_genes), up_genes))
colnames(up_genes)[1] <- "ensemblID"
up_genes$ensemblID <- str_extract(up_genes$ensemblID, "ENSMUSG...........")
up_genes <- merge(up_genes, TDDindexes, by = "ensemblID")
dup <- up_genes[!duplicated(up_genes), "ensemblID"]
up_genes <- up_genes[up_genes$ensemblID %in% dup,]

gdata <- melt(up_genes[,c(1,2,3,8:11)], measure.vars = c("asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA"))
gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] <- gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] * 2 ^ gdata[gdata$variable == "asTDDindex_LymphoA", "log2FoldChange"]

wilcox.test(x = gdata[gdata$variable == "asTDDindex_LymphoR", "value"],
            y = gdata[gdata$variable == "asTDDindex_LymphoA", "value"])

p1 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = value)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("absolute TDD index") +
  geom_boxplot(width = 0.1) + ggtitle("IndexTDDas (3hCHX) of uptranslated genes ")

p2 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = log10(baseMean))) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") +  ylab("log10(Ribosome occupancy)") +
  geom_boxplot(width = 0.1)  + ggtitle("RiboDens of uptranslated genes ")

grid.arrange(p1, p2, ncol = 2) 

down_genes = as.data.frame(cbind(rownames(down_genes), down_genes))
colnames(down_genes)[1] <- "ensemblID"
down_genes$ensemblID <- str_extract(down_genes$ensemblID, "ENSMUSG...........")
down_genes <- merge(down_genes, TDDindexes, by = "ensemblID")

gdata <- melt(down_genes[,c(1,2,3,8:11)], measure.vars = c("asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA"))
gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] <- gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] * 2 ^ gdata[gdata$variable == "asTDDindex_LymphoA", "log2FoldChange"]

wilcox.test(x = gdata[gdata$variable == "asTDDindex_LymphoR", "value"],
            y = gdata[gdata$variable == "asTDDindex_LymphoA", "value"])

p1 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = value)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("absolute TDD index") +
  geom_boxplot(width = 0.1) + ggtitle("IndexTDDas (3hCHX) of downtranslated genes ")

p2 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = baseMean)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("log10(Ribosome occupancy)") +
  geom_boxplot(width = 0.1) + scale_y_log10() + ggtitle("RiboDens of uptranslated genes ")

grid.arrange(p1, p2, ncol = 2) 

dev.off()

#### stralala

res2 <- as.data.frame(res)
res2 <- res2[!is.na(res2$log2FoldChange),]

res2$ensemblID <- str_extract(rownames(res2), "ENSMUSG...........")
res2 <- merge(res2, TDDindexes, by = "ensemblID")
res2$deltaTDD <- (res2$asTDDindex_LymphoA - res2$asTDDindex_LymphoR)

pdf("results/RiboOc_vs_deltaTDD.pdf",
    width = 11,
    height = 8.5)

#"#D55E00"

ggplot(data = res2, aes(x = log2FoldChange, y = deltaTDD)) + 
  geom_point(alpha = 0.5, color = "grey") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange > 0), aes(x = log2FoldChange, y = deltaTDD), alpha = 0.5, color = "magenta") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange < 0), aes(x = log2FoldChange, y = deltaTDD), alpha = 0.95, color = "#56B4E9") + 
 # ylim(-10,10) + 
  geom_smooth(method = "glm") +
  geom_density_2d(color = "black", alpha = 0.2) +
  ggtitle("With 3h CHX TDD index") 
dev.off()


# TDD index with Harringtonine ------------

diff_gene <- res[!is.na(res$padj) & res$padj < 0.05,]
up_genes <- res[!is.na(res$padj) & res$padj < 0.05 & res$log2FoldChange > 0,]
down_genes <- res[!is.na(res$padj) & res$padj < 0.05 & res$log2FoldChange < 0,]

TDDindexes_HAR <- dplyr::select(table, 
                                "EnsemblID", 
                                "asIndexTDD_t3TripTripHAR.0hTrip_LR",
                                "asIndexTDD_t3TripTripHAR.0hTrip_LA", 
                                "RiboDens_LymphoR",
                                "RiboDens_LymphoA"
)
TDDindexes_HAR$RiboDens_LymphoR <- as.numeric(as.character(TDDindexes_HAR$RiboDens_LymphoR))
TDDindexes_HAR$RiboDens_LymphoA <- as.numeric(as.character(TDDindexes_HAR$RiboDens_LymphoA))
colnames(TDDindexes_HAR) <- c("ensemblID", "asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA")

pdf("results/TDDindex_of_diff_translated_genes_HARR.pdf",
    width = 8.5,
    height = 11)

# Diff genes (up + down)
diff_gene = as.data.frame(cbind(rownames(diff_gene), diff_gene))
colnames(diff_gene)[1] <- "ensemblID"
diff_gene$ensemblID <- str_extract(diff_gene$ensemblID, "ENSMUSG...........")
diff_gene <- merge(diff_gene, TDDindexes_HAR, by = "ensemblID")

gdata <- melt(diff_gene[,c(1,2,3,8:11)], measure.vars = c("asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA"))
gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] <- gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] * 2 ^ gdata[gdata$variable == "asTDDindex_LymphoA", "log2FoldChange"]

p1 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = value)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("absolute TDD index") +
  geom_boxplot(width = 0.1) + ggtitle("IndexTDDas (3hHAR) of up + down - translated genes ")

p2 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = baseMean)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("log10(Ribosome occupancy)") +
  geom_boxplot(width = 0.1) + scale_y_log10() + ggtitle("RiboDens of uptranslated genes ")

grid.arrange(p1, p2, ncol = 2) 

up_genes = as.data.frame(cbind(rownames(up_genes), up_genes))
colnames(up_genes)[1] <- "ensemblID"
up_genes$ensemblID <- str_extract(up_genes$ensemblID, "ENSMUSG...........")
up_genes <- merge(up_genes, TDDindexes_HAR, by = "ensemblID")
dup <- up_genes[!duplicated(up_genes), "ensemblID"]
up_genes <- up_genes[up_genes$ensemblID %in% dup,]

gdata <- melt(up_genes[,c(1,2,3,8:11)], measure.vars = c("asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA"))
gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] <- gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] * 2 ^ gdata[gdata$variable == "asTDDindex_LymphoA", "log2FoldChange"]

wilcox.test(x = gdata[gdata$variable == "asTDDindex_LymphoR", "value"],
            y = gdata[gdata$variable == "asTDDindex_LymphoA", "value"])

p1 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = value)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("absolute TDD index") +
  geom_boxplot(width = 0.1) + ggtitle("IndexTDDas (3hHAR) of uptranslated genes ")

p2 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = log10(baseMean))) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") +  ylab("log10(Ribosome occupancy)") +
  geom_boxplot(width = 0.1)  + ggtitle("RiboDens of uptranslated genes ")

grid.arrange(p1, p2, ncol = 2) 

down_genes = as.data.frame(cbind(rownames(down_genes), down_genes))
colnames(down_genes)[1] <- "ensemblID"
down_genes$ensemblID <- str_extract(down_genes$ensemblID, "ENSMUSG...........")
down_genes <- merge(down_genes, TDDindexes_HAR, by = "ensemblID")

gdata <- melt(down_genes[,c(1,2,3,8:11)], measure.vars = c("asTDDindex_LymphoR", "asTDDindex_LymphoA", "RiboDens_LymphoR", "RiboDens_LymphoA"))
gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] <- gdata[gdata$variable == "asTDDindex_LymphoA", "baseMean"] * 2 ^ gdata[gdata$variable == "asTDDindex_LymphoA", "log2FoldChange"]

wilcox.test(x = gdata[gdata$variable == "asTDDindex_LymphoR", "value"],
            y = gdata[gdata$variable == "asTDDindex_LymphoA", "value"])

p1 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = value)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("absolute TDD index") +
  geom_boxplot(width = 0.1) + ggtitle("IndexTDDas (3hHAR) of downtranslated genes ")

p2 <- ggplot(data = gdata %>% filter(variable == "asTDDindex_LymphoR" | variable == "asTDDindex_LymphoA"), 
             aes(x = variable, y = baseMean)) + 
  geom_violin(aes(fill = variable)) + 
  geom_jitter(width = 0.1, alpha = 0.5) + theme(legend.position="none") + ylab("log10(Ribosome occupancy)") +
  geom_boxplot(width = 0.1) + scale_y_log10() + ggtitle("RiboDens of uptranslated genes ")

grid.arrange(p1, p2, ncol = 2) 

dev.off()

#### stralala

res2 <- as.data.frame(res)
res2 <- res2[!is.na(res2$log2FoldChange),]

res2$ensemblID <- str_extract(rownames(res2), "ENSMUSG...........")
res2 <- merge(res2, TDDindexes_HAR, by = "ensemblID")
res2$deltaTDD <- (res2$asTDDindex_LymphoA - res2$asTDDindex_LymphoR)

pdf("results/RiboOc_vs_deltaTDD_HARR.pdf",
    width = 11,
    height = 8.5)

#"#D55E00"

ggplot(data = res2, aes(x = log2FoldChange, y = deltaTDD)) + 
  geom_point(alpha = 0.5, color = "grey") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange > 0), aes(x = log2FoldChange, y = deltaTDD), alpha = 0.5, color = "magenta") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange < 0), aes(x = log2FoldChange, y = deltaTDD), alpha = 0.95, color = "#56B4E9") + 
  # ylim(-10,10) + 
  geom_smooth(method = "glm") +
  geom_density_2d(color = "black", alpha = 0.2) +
  ggtitle("With 3h Harringtonine TDD index")
dev.off()

# with delta Deg3h----------

res2 <- as.data.frame(res)
res2 <- res2[!is.na(res2$log2FoldChange),]

res2$ensemblID <- str_extract(rownames(res2), "ENSMUSG...........")
res2 <- merge(res2, TDDindexes, by = "ensemblID")
res2$deltaDeg <- (res2$Deg3h_LA - res2$Deg3h_LR)

pdf("results/RiboOc_vs_deltaDeg3h.pdf",
    width = 11,
    height = 8.5)

#"#D55E00"

ggplot(data = res2, aes(x = log2FoldChange, y = deltaDeg)) + 
  geom_point(alpha = 0.5, color = "grey") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange > 0), aes(x = log2FoldChange, y = deltaDeg), alpha = 0.5, color = "magenta") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange < 0), aes(x = log2FoldChange, y = deltaDeg), alpha = 0.95, color = "#56B4E9") + 
  # ylim(-10,10) + 
  geom_smooth(method = "glm") +
  geom_density_2d(color = "black", alpha = 0.2) +
  ggtitle("Degradation rate calculated at 3h with Tritolide vs log2FoldChange in translation")
dev.off()

# with asnonTDD----------

res2 <- as.data.frame(res)
res2 <- res2[!is.na(res2$log2FoldChange),]

res2$ensemblID <- str_extract(rownames(res2), "ENSMUSG...........")
res2 <- merge(res2, TDDindexes, by = "ensemblID")
res2$deltanonTDDas <- (res2$Deg3h_LA - res2$asTDDindex_LymphoA) - (res2$Deg3h_LR - res2$asTDDindex_LymphoR)

pdf("results/RiboOc_vs_deltaas_nonTDDindex.pdf",
    width = 11,
    height = 8.5)

#"#D55E00"

ggplot(data = res2, aes(x = log2FoldChange, y = deltanonTDDas)) + 
  geom_point(alpha = 0.5, color = "grey") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange > 0), aes(x = log2FoldChange, y = deltanonTDDas), alpha = 0.5, color = "magenta") + 
  geom_point(data = filter(res2, padj < 0.05 & log2FoldChange < 0), aes(x = log2FoldChange, y = deltanonTDDas), alpha = 0.95, color = "#56B4E9") + 
  # ylim(-10,10) + 
  geom_smooth(method = "glm") +
  geom_density_2d(color = "black", alpha = 0.2) +
  ggtitle("DELTA as-non-TDD index calculated at 3h with Tritolide vs log2FoldChange in translation")
dev.off()


# ----------
res2 <- as.data.frame(res)
res2 <- res2[!is.na(res2$log2FoldChange),]

res2$ensemblID <- str_extract(rownames(res2), "ENSMUSG...........")
res2 <- merge(res2, TDDindexes, by = "ensemblID")
res2$deltaTDDas <- (res2$asTDDindex_LymphoA - res2$asTDDindex_LymphoR)
res2$deltanonTDDas <- (res2$Deg3h_LA - res2$asTDDindex_LymphoA) - (res2$Deg3h_LR - res2$asTDDindex_LymphoR)
res2$log2FoldChangeColor <- "middle"
res2$log2FoldChangeColor[res2$log2FoldChange > 0] <- "greater than 0"
res2$log2FoldChangeColor[res2$log2FoldChange < -0] <- "lower than -0"
pdf("results/deltaas_TDDindex_vs_deltaas_nonTDDindex_RiboOc_color.pdf",
    width = 11,
    height = 8.5)

#"#D55E00"

ggplot(data = res2, aes(x = deltanonTDDas, y = deltaTDDas, color = log2FoldChange)) + 
  geom_point() + 
  geom_smooth(method = "glm") +
  geom_abline(slope = -1, intercept = 0, color = "red", alpha = 0.5)+
  geom_density_2d(color = "black", alpha = 0.2) + scale_color_gradient2(low="#56B4E9", high="red", mid = "#F8F8FF", midpoint = 0) +
  ggtitle("DELTA as-non-TDD index  vs DELTA as-TDD index calculated at 3h with Tritolide")
dev.off()


