########################################
######    TDD in gene subset      ######
######         2020.01.20         ######
########################################

# strategy : boxplot IndexTDD of differents gene subsets (i.e. 5'TOP genes, ARE genes etc...)

# 0. Set env --------------------------------------------------------------

setwd("~/RMI2/Projet_TDD/20200114_Normalisation")

library(ggplot2)
theme_set(theme_bw())
library(reshape2)
library(DESeq2)
library(stringr)
library(dplyr)
library(gridExtra)
library("biomaRt")

load(file = "results/database.RData")

# 1. Get gene lists ------------------------------------------------------------
TOP_sabatini <- read.csv("data/sabatini_top_rnas.csv")
TOP_sabatini <- as.character(TOP_sabatini[, 1])
TOP_sabatini_nonRP <- read.csv("data/sabatini_top_rnas_nonRP.csv")
TOP_sabatini_nonRP <- as.character(TOP_sabatini_nonRP[, 1])

features <- list(TOP_sabatini, TOP_sabatini_nonRP)
names(features) = c("TOP_sabatini", "TOP_sabatini_nonRP")

# boxplots ----------------------------------------------------------------

## Lympho R
sub_data <- table %>% dplyr::select(EnsemblID,
                                    GeneName,
                                    asIndexTDD_t3TripTripCHX.0hTrip_LR, 
                                    asIndexTDD_t3TripTripCHX.0hTrip_LA,
                                    RiboDens_LymphoR,
                                    RiboDens_LymphoA)

TOP_sabatini <- sub_data[sub_data$GeneName %in% TOP_sabatini, ]
feature = "TOP_sabatini"
TOP_sabatini <- cbind(TOP_sabatini, feature)

TOP_sabatini_nonRP = sub_data[sub_data$GeneName %in% TOP_sabatini_nonRP, ]
feature = "TOP_sabatini_nonRP"
TOP_sabatini_nonRP <- cbind(TOP_sabatini_nonRP, feature)

feature = "all"
lymphoR = cbind(sub_data, feature)

data = rbind(
  lymphoR,
  TOP_sabatini,
  TOP_sabatini_nonRP
)
data <- as_tibble(data)
data$RiboDens_LymphoR <- as.numeric(as.character(data$RiboDens_LymphoR))
data$RiboDens_LymphoA <- as.numeric(as.character(data$RiboDens_LymphoA))

data_m <- as_tibble(melt(data, measure.vars = c("asIndexTDD_t3TripTripCHX.0hTrip_LR", "asIndexTDD_t3TripTripCHX.0hTrip_LA", "RiboDens_LymphoR", "RiboDens_LymphoA" )))
data_m$value <- as.numeric(as.character(data_m$value))
data_m_1 <- data_m %>% filter(variable == "asIndexTDD_t3TripTripCHX.0hTrip_LR" |
                                variable == "asIndexTDD_t3TripTripCHX.0hTrip_LA" )
data_m_2 <- data_m %>% filter(variable == "RiboDens_LymphoR" |
                                variable == "RiboDens_LymphoA" )

pdf(file = "results/boxplot_TOPgenes.pdf",
    width = 5,
    height = 10)
ggplot(data = data_m_1 , 
       aes(x = variable, y = value, fill = feature, colour = feature)) +
  geom_boxplot(show.legend = FALSE, alpha = 0.5 ) + ylab("absolute IndexTDD") +
  scale_fill_manual( values = c("#7AA6DCFF", "#0073C2FF", "#003C67FF")) +
  scale_color_manual( values = c("#7AA6DCFF", "#0073C2FF", "#003C67FF")) +
  ylim(-0.5, 1.35) +
  geom_abline(slope = 0, intercept = median(data$asIndexTDD_t3TripTripCHX.0hTrip_LR), alpha = 0.6, linetype="dashed") + 
  ggtitle("absolute TDD index in resting lympho")

ggplot(data = data_m_2 , 
       aes(x = variable, y = value, fill = feature, colour = feature)) +
  geom_boxplot(show.legend = FALSE, alpha = 0.5 ) + ylab("Ribosome Density") +
  scale_y_log10()+
  scale_fill_manual( values = c("#7AA6DCFF", "#0073C2FF", "#003C67FF")) +
  scale_color_manual( values = c("#7AA6DCFF", "#0073C2FF", "#003C67FF")) +
 # ylim(-5,5) +
  geom_abline(slope = 0, intercept = log10(median(as.numeric(as.character(sub_data$RiboDens_LymphoR)), na.rm = TRUE)), alpha = 0.6, linetype = "dashed") + 
  ggtitle("Ribosome Density in resting lympho")

dev.off()

# IndexTDDas LR vs LA + Top genes --------------
pdf(file = "results/scaterPlot_TOPgenes.pdf")
ggplot(data = data) +
  geom_point(aes(x = asIndexTDD_t3TripTripCHX.0hTrip_LR, y = asIndexTDD_t3TripTripCHX.0hTrip_LA, colour = feature), alpha = 0.5 ) +
  geom_density_2d(aes(x = asIndexTDD_t3TripTripCHX.0hTrip_LR, y = asIndexTDD_t3TripTripCHX.0hTrip_LA), color = "black", alpha = 0.2) +
  scale_color_manual( values = c("#7AA6DCFF", "red", "green")) +
  ggtitle("absolute TDD index in resting lympho")

ggplot(data = data) +
  geom_point(aes(x = RiboDens_LymphoR, y = RiboDens_LymphoA, colour = feature), alpha = 0.5 ) +
  geom_density_2d(aes(x = RiboDens_LymphoR, y = RiboDens_LymphoA), color = "black", alpha = 0.2) +
  scale_color_manual( values = c("#7AA6DCFF", "red", "green")) +
  scale_x_log10() + scale_y_log10()
  ggtitle("absolute TDD index in resting lympho")
  
dev.off()
