library(tibble)
library(tidyr)
library(dplyr)
library(ggplot2)
library(gridExtra)
theme_set(theme_bw())

setwd("~/RMI2/Projet_TDD/20200114_Normalisation")
load("results/database.RData")

table <- as_tibble(table %>% dplyr::select("Length.transcrit",
                                            "GC%.transcrit",
                                            "Length.cds",
                                            "GC%.cds",
                                            "Length.utr3",
                                            "GC%.utr3",
                                            "Length.utr5",
                                            "GC%.utr5",
                                            "IntronUTR3",
                                            "n-uORF",
                                            "sumKozakuOFR",
                                            "asIndexTDD_t3TripTripCHX.0hTrip_LR",
                                            "asIndexTDD_t3TripTripCHX.0hTrip_LA",
                                            "Deg3hTrip_LR",
                                            "Deg1hTrip_LR",
                                            "Deg3hTrip_LA",
                                            "Deg1hTrip_LA",
                                            "RiboDens_LymphoR",
                                            "RiboDens_LymphoA"
                            )
        )
table$RiboDens_LymphoR <- as.numeric(as.character(table$RiboDens_LymphoR))
table$RiboDens_LymphoA <- as.numeric(as.character(table$RiboDens_LymphoA))
index <- colnames(table)

# 2. asTDDindex in Lympho --------------------------------------------------------------

pdf(file = "results/04_corr_binned_asTDDindex_lympho_ensembl_median.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = asIndexTDD_t3TripTripCHX.0hTrip_LR, y = asIndexTDD_t3TripTripCHX.0hTrip_LA)) + 
  geom_point() + 
  ggtitle("asTDDindex : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("asIndexTDD_t3TripTripCHX.0hTrip_LR","asIndexTDD_t3TripTripCHX.0hTrip_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$asIndexTDD_t3TripTripCHX.0hTrip_LR[((j - bin) + 1):j])
      m3 = median(sub_data$asIndexTDD_t3TripTripCHX.0hTrip_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "asTDDindex_in_LR",  "asTDDindex_in_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = asTDDindex_in_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = asTDDindex_in_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()


# as non-TDD index --------------

table$asnonTDDindex_LR <- table$Deg3hTrip_LR - table$asIndexTDD_t3TripTripCHX.0hTrip_LR
table$asnonTDDindex_LA <- table$Deg3hTrip_LA - table$asIndexTDD_t3TripTripCHX.0hTrip_LA

index <- colnames(table)

pdf(file = "results/04_corr_binned_asNonTDDindex_lympho_ensembl_median.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = asIndexTDD_t3TripTripCHX.0hTrip_LR, y = asIndexTDD_t3TripTripCHX.0hTrip_LA)) + 
  geom_point() + 
  ggtitle("asTDDindex : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("asnonTDDindex_LR","asnonTDDindex_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$asnonTDDindex_LR[((j - bin) + 1):j])
      m3 = median(sub_data$asnonTDDindex_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "asNonTDDindex_in_LR",  "asNonTDDindex_in_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = asNonTDDindex_in_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = asNonTDDindex_in_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()

# Deg3h in lymphocytes --------------

pdf(file = "results/04_corr_binned_Deg3hTrip_mydb_lympho.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = Deg3hTrip_LR, y = Deg3hTrip_LA)) + 
  geom_point() + 
  ggtitle("Degradation rate at 3h : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("Deg3hTrip_LR","Deg3hTrip_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$Deg3hTrip_LR[((j - bin) + 1):j])
      m3 = median(sub_data$Deg3hTrip_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "Deg3hTrip_LR",  "Deg3hTrip_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = Deg3hTrip_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = Deg3hTrip_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()
