library(tibble)
library(tidyr)
library(dplyr)
library(ggplot2)
library(gridExtra)
theme_set(theme_bw())

setwd("~/RMI2/Projet_TDD/20200114_Normalisation")
db <- "data/2020-01-20_13-34-17_Subset_Data.csv"

# 1. prepare datas --------------------------------------------------------

table <- as_tibble(read.csv(db))
table <- table %>% dplyr::select("trans_length",
                                 "CDS_length",
                                 "Length.utr5",
                                 "Length.utr3",
                                 "Length.cds",
                          "n_m6ASeq_Peaks",
                          "total_m6ASeq_score",
                          "UTR5_length",
                          "UTR3_length",
                          "asIndexTDD_t3TripTripCHX.0hTrip_LR",
                          "asIndexTDD_t3TripTripCHX.0hTrip_LA",
                          "Exp_UTR3_Activated_CD4_T_cells_A1_Mean_l",
                          "Exp_UTR3_Activated_CD4_T_cells_A2_Mean_l",
                          "Exp_UTR3_Activated_CD4_T_cells_A3_Mean_l",
                          "Exp_UTR3_LPS_Stimulated_Macrophages_m1_Mean_l",
                          "Exp_UTR3_LPS_Stimulated_Macrophages_m2_Mean_l",
                          "Exp_UTR3_LPS_Stimulated_Macrophages_m3_Mean_l",
                          "Exp_UTR3_Resting_CD4_T_cells_R1_Mean_l",
                          "Exp_UTR3_Resting_CD4_T_cells_R2_Mean_l",
                          "Exp_UTR3_Resting_CD4_T_cells_R3_Mean_l",
                          "Exp_UTR3_Unstimulated_Macrophages_i1_Mean_l",
                          "Exp_UTR3_Unstimulated_Macrophages_i2_Mean_l",
                          "Exp_UTR3_Unstimulated_Macrophages_i3_Mean_l",
                          "CDS_DG",
                          "UTR5_DG",
                          "UTR3_DG",
                          "X47UTR5.30CDS_DG",
                          "X31CDS.End_DG",
                          "Kozack_score_frequency",
                          "Kozack_score_efficiency",
                          "Kozack_score_dinucleotide",
                          "n_introns_in_UTR5",
                          "n_CDS_fragments",
                          "n_introns_in_UTR3",
                          "n_exon",
                          "n_intron",
                          "RiboDens_LymphoR",
                          "RiboDens_LymphoA",
                          "RiboDens_MacroR",
                          "RiboDens_MacroA",
                          "Deg3hTrip_LR",
                          "Deg3hTrip_LA",
                          "Deg3hTrip_MR",
                          "Deg3hTrip_MA",
                          "Stretches_AAA_AAG_score",
                          "Stretches_AAA_AAG_pondarated_score",
                          "Stretches_GAC_GAT_score",
                          "Stretches_GAC_GAT_pondarated_score",
                          "Stretches_GAA_GAG_score",
                          "Stretches_GAA_GAG_pondarated_score",
                          "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_score",
                          "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_pondarated_score",
                          "percent_ALA_A",
                          "percent_ARG_R",
                          "percent_ASN_N",
                          "percent_ASP_D",
                          "percent_CYS_C",
                          "percent_GLU_E",
                          "percent_GLN_Q",
                          "percent_GLY_G",
                          "percent_HIS_H",
                          "percent_ILE_I",
                          "percent_LEU_L",
                          "percent_LYS_K",
                          "percent_MET_M",
                          "percent_PHE_F",
                          "percent_PRO_P",
                          "percent_SER_S",
                          "percent_THR_T",
                          "percent_TRP_W",
                          "percent_TYR_Y",
                          "percent_VAL_V"
                    )

table$UTR3_LA <- rowMeans(table %>% dplyr::select("Exp_UTR3_Activated_CD4_T_cells_A1_Mean_l",
                                                 "Exp_UTR3_Activated_CD4_T_cells_A2_Mean_l",
                                                 "Exp_UTR3_Activated_CD4_T_cells_A3_Mean_l"))
table$UTR3_LR <- rowMeans(table %>% dplyr::select("Exp_UTR3_Resting_CD4_T_cells_R1_Mean_l",
                                                  "Exp_UTR3_Resting_CD4_T_cells_R2_Mean_l",
                                                  "Exp_UTR3_Resting_CD4_T_cells_R3_Mean_l"))
table$UTR3_MA <- rowMeans(table %>% dplyr::select("Exp_UTR3_LPS_Stimulated_Macrophages_m1_Mean_l",
                                                  "Exp_UTR3_LPS_Stimulated_Macrophages_m2_Mean_l",
                                                  "Exp_UTR3_LPS_Stimulated_Macrophages_m3_Mean_l"))
table$UTR3_MR <- rowMeans(table %>% dplyr::select( "Exp_UTR3_Unstimulated_Macrophages_i1_Mean_l",
                                                   "Exp_UTR3_Unstimulated_Macrophages_i2_Mean_l",
                                                   "Exp_UTR3_Unstimulated_Macrophages_i3_Mean_l"))
table <- dplyr::select(table, -c("Exp_UTR3_Activated_CD4_T_cells_A1_Mean_l",
                          "Exp_UTR3_Activated_CD4_T_cells_A2_Mean_l",
                          "Exp_UTR3_Activated_CD4_T_cells_A3_Mean_l",
                          "Exp_UTR3_LPS_Stimulated_Macrophages_m1_Mean_l",
                          "Exp_UTR3_LPS_Stimulated_Macrophages_m2_Mean_l",
                          "Exp_UTR3_LPS_Stimulated_Macrophages_m3_Mean_l",
                          "Exp_UTR3_Resting_CD4_T_cells_R1_Mean_l",
                          "Exp_UTR3_Resting_CD4_T_cells_R2_Mean_l",
                          "Exp_UTR3_Resting_CD4_T_cells_R3_Mean_l",
                          "Exp_UTR3_Unstimulated_Macrophages_i1_Mean_l",
                          "Exp_UTR3_Unstimulated_Macrophages_i2_Mean_l",
                          "Exp_UTR3_Unstimulated_Macrophages_i3_Mean_l"))

table$CDS_DG <- table$CDS_DG / table$CDS_length
table$UTR5_DG <- table$UTR5_DG / table$UTR5_length
table$UTR3_DG <- table$UTR3_DG / table$UTR3_length

table$X31CDS.End_DG <-  table$X31CDS.End_DG / (table$CDS_length - 30)

# 2. asTDDindex in Lympho --------------------------------------------------------------
index <- c("trans_length",
           "CDS_length",
           "n_m6ASeq_Peaks",
           "total_m6ASeq_score",
           "UTR5_length",
           "UTR3_length",
           "UTR3_LR",
           "UTR3_LA",
           "RiboDens_LymphoR",
           "RiboDens_LymphoA",
           "CDS_DG",
           "UTR5_DG",
           "UTR3_DG",
           "X47UTR5.30CDS_DG",
           "X31CDS.End_DG",
           "Kozack_score_frequency",
           "Kozack_score_efficiency",
           "Kozack_score_dinucleotide",
           "n_introns_in_UTR5",
           "n_CDS_fragments",
           "n_introns_in_UTR3",
           "n_exon",
           "n_intron",
           "Deg3hTrip_LR",
           "Deg3hTrip_LA",
           "Stretches_AAA_AAG_score",
           "Stretches_AAA_AAG_pondarated_score",
           "Stretches_GAC_GAT_score",
           "Stretches_GAC_GAT_pondarated_score",
           "Stretches_GAA_GAG_score",
           "Stretches_GAA_GAG_pondarated_score",
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_score",
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_pondarated_score",
           "percent_ALA_A",
           "percent_ARG_R",
           "percent_ASN_N",
           "percent_ASP_D",
           "percent_CYS_C",
           "percent_GLU_E",
           "percent_GLN_Q",
           "percent_GLY_G",
           "percent_HIS_H",
           "percent_ILE_I",
           "percent_LEU_L",
           "percent_LYS_K",
           "percent_MET_M",
           "percent_PHE_F",
           "percent_PRO_P",
           "percent_SER_S",
           "percent_THR_T",
           "percent_TRP_W",
           "percent_TYR_Y",
           "percent_VAL_V")

pdf(file = "results/04_corr_binned_asTDDindex_lympho.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = asIndexTDD_t3TripTripCHX.0hTrip_LR, y = asIndexTDD_t3TripTripCHX.0hTrip_LA)) + 
  geom_point() + 
  ggtitle("asTDDindex : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("asIndexTDD_t3TripTripCHX.0hTrip_LR","asIndexTDD_t3TripTripCHX.0hTrip_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$asIndexTDD_t3TripTripCHX.0hTrip_LR[((j - bin) + 1):j])
      m3 = median(sub_data$asIndexTDD_t3TripTripCHX.0hTrip_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "asTDDindex_in_LR",  "asTDDindex_in_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = asTDDindex_in_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = asTDDindex_in_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()

# 3. RiboDensity in Lympho --------------------------------------------------------------
index <- c("trans_length",
              "CDS_length",
              "n_m6ASeq_Peaks",
              "total_m6ASeq_score",
              "UTR5_length",
              "UTR3_length",
              "UTR3_LR",
              "UTR3_LA",
              "CDS_DG",
              "UTR5_DG",
              "UTR3_DG",
              "X47UTR5.30CDS_DG",
              "X31CDS.End_DG",
              "Kozack_score_frequency",
              "Kozack_score_efficiency",
              "Kozack_score_dinucleotide",
              "n_introns_in_UTR5",
              "n_CDS_fragments",
              "n_introns_in_UTR3",
              "n_exon",
              "n_intron",
              "Deg3hTrip_LR",
              "Deg3hTrip_LA",
              "Stretches_AAA_AAG_score",
              "Stretches_AAA_AAG_pondarated_score",
              "Stretches_GAC_GAT_score",
              "Stretches_GAC_GAT_pondarated_score",
              "Stretches_GAA_GAG_score",
              "Stretches_GAA_GAG_pondarated_score",
              "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_score",
              "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_pondarated_score",
              "percent_ALA_A",
              "percent_ARG_R",
              "percent_ASN_N",
              "percent_ASP_D",
              "percent_CYS_C",
              "percent_GLU_E",
              "percent_GLN_Q",
              "percent_GLY_G",
              "percent_HIS_H",
              "percent_ILE_I",
              "percent_LEU_L",
              "percent_LYS_K",
              "percent_MET_M",
              "percent_PHE_F",
              "percent_PRO_P",
              "percent_SER_S",
              "percent_THR_T",
              "percent_TRP_W",
              "percent_TYR_Y",
              "percent_VAL_V")

pdf(file = "results/04_corr_binned_RiboDens_lympho.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = log10(RiboDens_LymphoR), y = log10(RiboDens_LymphoA))) + 
  geom_point() + 
  ggtitle("Ribo density : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("RiboDens_LymphoR","RiboDens_LymphoA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$RiboDens_LymphoR[((j - bin) + 1):j])
      m3 = median(sub_data$RiboDens_LymphoA[((j - bin) + 1):j])
        
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "RiboDens_in_LR",  "RiboDens_in_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = RiboDens_in_LR)) + 
          ggtitle(paste("\t\t\tResting Lymphocytes")) + 
          xlab(i) + 
          geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = RiboDens_in_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()

# 3. as non-TDD index in Lympho --------------------------------------------------------------

table$asnonTDDindex_LR <- table$Deg3hTrip_LR - table$asIndexTDD_t3TripTripCHX.0hTrip_LR
table$asnonTDDindex_LA <- table$Deg3hTrip_LA - table$asIndexTDD_t3TripTripCHX.0hTrip_LA

index <- c("trans_length",
           "RiboDens_LymphoR",
           "RiboDens_LymphoA",
           "CDS_length",
           "n_m6ASeq_Peaks",
           "total_m6ASeq_score",
           "UTR5_length",
           "UTR3_length",
           "UTR3_LR",
           "UTR3_LA",
           "CDS_DG",
           "UTR5_DG",
           "UTR3_DG",
           "X47UTR5.30CDS_DG",
           "X31CDS.End_DG",
           "Kozack_score_frequency",
           "Kozack_score_efficiency",
           "Kozack_score_dinucleotide",
           "n_introns_in_UTR5",
           "n_CDS_fragments",
           "n_introns_in_UTR3",
           "n_exon",
           "n_intron",
           "Deg3hTrip_LR",
           "Deg3hTrip_LA",
           "Stretches_AAA_AAG_score",
           "Stretches_AAA_AAG_pondarated_score",
           "Stretches_GAC_GAT_score",
           "Stretches_GAC_GAT_pondarated_score",
           "Stretches_GAA_GAG_score",
           "Stretches_GAA_GAG_pondarated_score",
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_score",
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_pondarated_score",
           "percent_ALA_A",
           "percent_ARG_R",
           "percent_ASN_N",
           "percent_ASP_D",
           "percent_CYS_C",
           "percent_GLU_E",
           "percent_GLN_Q",
           "percent_GLY_G",
           "percent_HIS_H",
           "percent_ILE_I",
           "percent_LEU_L",
           "percent_LYS_K",
           "percent_MET_M",
           "percent_PHE_F",
           "percent_PRO_P",
           "percent_SER_S",
           "percent_THR_T",
           "percent_TRP_W",
           "percent_TYR_Y",
           "percent_VAL_V")

pdf(file = "results/04_corr_binned_asNonTDDindex_lympho.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = (asnonTDDindex_LR), y = (asnonTDDindex_LA))) + 
  geom_point() + 
  ggtitle("Ribo density : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("asnonTDDindex_LR","asnonTDDindex_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$asnonTDDindex_LR[((j - bin) + 1):j])
      m3 = median(sub_data$asnonTDDindex_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "asnonTDDindex_LR",  "asnonTDDindex_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = asnonTDDindex_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = asnonTDDindex_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()

# 4. Deg3hTrip in Lympho -----------------------------------------------------------------

index <- c("trans_length",
           "RiboDens_LymphoR",
           "RiboDens_LymphoA",
           "CDS_length",
           "n_m6ASeq_Peaks",
           "total_m6ASeq_score",
           "UTR5_length",
           "UTR3_length",
           "UTR3_LR",
           "UTR3_LA",
           "CDS_DG",
           "UTR5_DG",
           "UTR3_DG",
           "X47UTR5.30CDS_DG",
           "X31CDS.End_DG",
           "Kozack_score_frequency",
           "Kozack_score_efficiency",
           "Kozack_score_dinucleotide",
           "n_introns_in_UTR5",
           "n_CDS_fragments",
           "n_introns_in_UTR3",
           "n_exon",
           "n_intron",
           "Stretches_AAA_AAG_score",
           "Stretches_AAA_AAG_pondarated_score",
           "Stretches_GAC_GAT_score",
           "Stretches_GAC_GAT_pondarated_score",
           "Stretches_GAA_GAG_score",
           "Stretches_GAA_GAG_pondarated_score",
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_score",
           "Stretches_AAA_AAG_GAC_GAT_GAA_GAG_pondarated_score",
           "percent_ALA_A",
           "percent_ARG_R",
           "percent_ASN_N",
           "percent_ASP_D",
           "percent_CYS_C",
           "percent_GLU_E",
           "percent_GLN_Q",
           "percent_GLY_G",
           "percent_HIS_H",
           "percent_ILE_I",
           "percent_LEU_L",
           "percent_LYS_K",
           "percent_MET_M",
           "percent_PHE_F",
           "percent_PRO_P",
           "percent_SER_S",
           "percent_THR_T",
           "percent_TRP_W",
           "percent_TYR_Y",
           "percent_VAL_V")

pdf(file = "results/04_corr_binned_Deg3hTrip_lympho.pdf",
    width = 20,
    height = 10)

ggplot(table, aes(x = Deg3hTrip_LR, y = Deg3hTrip_LA)) + 
  geom_point() + 
  ggtitle("Degradation rate at 3h : Resting vs Actiated lymphocytes")

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("Deg3hTrip_LR","Deg3hTrip_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = colMeans(sub_data[((j - bin) + 1):j,i])
      m2 = median(sub_data$Deg3hTrip_LR[((j - bin) + 1):j])
      m3 = median(sub_data$Deg3hTrip_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "Deg3hTrip_LR",  "Deg3hTrip_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = Deg3hTrip_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = Deg3hTrip_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()

# 5. sqdfjhiqflfqsebjlsdrgqbk--------------------------------

table$DDeh <- table$Deg3hTrip_LA-table$Deg3hTrip_LR
table$DRiboDens <- table$RiboDens_LymphoA-table$RiboDens_LymphoR

ggplot(data = table, aes(x = DRiboDens, y = DDeh)) + 
  geom_point(alpha = 0.5) + 
  geom_smooth(method = "glm") +
  geom_density_2d(color = "black", alpha = 0.2) +
  xlim(-5,5) +
  ggtitle("With 3h Harringtonine TDD index")
dev.off()  

# 6. IndexTDDas normalized by RiboDens ---------------------

table$IndexTDDnorm_LR <- table$asIndexTDD_t3TripTripCHX.0hTrip_LR / table$RiboDens_LymphoR
table$IndexTDDnorm_LA <- table$asIndexTDD_t3TripTripCHX.0hTrip_LA / table$RiboDens_LymphoA



index <- c("Length.utr3", "Length.utr5")

pdf(file = "results/04_corr_binned_asTDDindexNorm_lympho.pdf",
    width = 20,
    height = 10)

for (i in index) {
  print(i)
  sub_data <- table %>% dplyr::select("IndexTDDnorm_LR","IndexTDDnorm_LA", i)
  sub_data <- na.exclude(sub_data)
  
  bin <- round(nrow(sub_data) / 300)
  tpm <- data.frame(matrix(nrow = nrow(sub_data) %% bin, ncol = 3))
  sub_data <- sub_data[order(c(unlist(sub_data[,i]))), ]
  
  c = 1
  for (j in 1:nrow(sub_data)) {
    if (j %% bin == 0) {
      m1 = median(c(unlist(sub_data[((j - bin) + 1):j,i])))
      m2 = median(sub_data$IndexTDDnorm_LR[((j - bin) + 1):j])
      m3 = median(sub_data$IndexTDDnorm_LA[((j - bin) + 1):j])
      
      tpm[c, 1] = m1
      tpm[c, 2] = m2
      tpm[c, 3] = m3
      c = c + 1
    }
  }
  colnames(tpm) <- c(i, "IndexTDDnorm_LR",  "IndexTDDnorm_LA")
  p1 <-ggplot(tpm, aes(x = tpm[,i], y = IndexTDDnorm_LR)) + 
    ggtitle(paste("\t\t\tResting Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  p2 <-ggplot(tpm, aes(x = tpm[,i], y = IndexTDDnorm_LA)) + 
    ggtitle(paste("\t\t\tActivated Lymphocytes")) + 
    xlab(i) + 
    geom_point()
  print(grid.arrange(p1, p2, ncol = 2))
}
dev.off()

pdf(file = "results/utr3length_vs_ribodens.pdf")
ggplot(data = table, aes(x = log10(UTR3_length), y = log10(UTR3_LR))) + 
  geom_point(alpha = 0.5) + 
  geom_abline(slope = 1, intercept = 0)

ggplot(data = table, aes(x = log10(Length.utr3), y = log10(UTR3_LR))) + 
  geom_point(alpha = 0.5) + 
  geom_abline(slope = 1, intercept = 0)

ggplot(data = table, aes(x = log10(Length.utr3), y = log10(UTR3_length))) + 
  geom_point(alpha = 0.5) + 
  geom_abline(slope = 1, intercept = 0)

ggplot(data = table, aes(x = (UTR3_LA-UTR3_LR), y = (asIndexTDD_t3TripTripCHX.0hTrip_LA - asIndexTDD_t3TripTripCHX.0hTrip_LR ))) + 
  geom_point(alpha = 0.5) + 
  geom_abline(intercept = 0) + xlim(-1000,1000) + 
  geom_abline(slope = 0)

ggplot(data = table, aes(x = (UTR3_LA-UTR3_LR), y = (RiboDens_LymphoA - RiboDens_LymphoR ))) + 
  geom_point(alpha = 0.5) + 
  geom_abline(intercept = 0) + xlim(-1000,1000) + 
  geom_abline(slope = 0)

ggplot(data = table, aes(x = (UTR3_LA-UTR3_LR), y = (UTR3_LR))) + 
  geom_point(alpha = 0.5) + xlim(-1000,1000) + ylim(0,7000)
dev.off()
  